#!/usr/bin/perl

use FileHandle;

my $base = FileHandle->new ();
my $out = FileHandle->new ();

$base->open ("skk-config-list", "r");

# read all lines (for sort)
my @list = <$base>;

$out->open ("skkconf_private.h", "w");

$out->print (header_init ());
$out->printf ("SkkConfItem itemp[] = {\n");
foreach (sort @list) {
	chop ($_);
	my @item = split ("\t", $_);
	$out->printf (qq|\t{%s, %s, \n\t"%s", %s, (gpointer)%s, FALSE},\n|, $item[2], $item[1], $item[0], $item[3], $item[4]);
}

$base->close ();
$out->printf ("};\n");
$out->print (header_end ());
$out->close ();

sub header_init ()
{
	return <<'EOF';
/*
 * LibSKK, a tiny Library to emulate SKK (Simple Kana Kanji Conversion)
 * 
 * Copyright (C) 2002 Motonobu Ichimura <famao@kondara.org>
 *
 * All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, and/or sell copies of the Software, and to permit persons
 * to whom the Software is furnished to do so, provided that the above
 * copyright notice(s) and this permission notice appear in all copies of
 * the Software and that both the above copyright notice(s) and this
 * permission notice appear in supporting documentation.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT
 * OF THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
 * HOLDERS INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL
 * INDIRECT OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING
 * FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
 * WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale, use
 * or other dealings in this Software without prior written authorization
 * of the copyright holder.
 *
 */

/* Id: $ */

/* vi:set ts=4 sw=4: */

#ifndef SKKCONF_PRIVATE_H
#define SKKCONF_PRIVATE_H
#include <glib.h>

#include "skktypes.h"

#define SKKCONF_DEFAULT_ITEM_SIZE	((sizeof (itemp))/(sizeof (itemp[0])))

EOF
}

sub header_end ()
{
	return <<'EOF';

#endif /* SKKCONF_PRIVATE_H */
EOF
}
