/***************************************************************************
 *   Copyright (C) 2004-2005 by Thomas Fischer                             *
 *   fischer@unix-ag.uni-kl.de                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include <qfile.h>
#include <qapplication.h>

#include <klocale.h>
#include <klineedit.h>
#include <kcombobox.h>
#include <kmessagebox.h>
#include <kdebug.h>
#include <kio/netaccess.h>
#include <kurl.h>

#include <fileimporterbibtex.h>
#include "webqueryspireshep.h"

namespace KBibTeX
{

    const QString WebQueryWizardSpiresHep::mirrorNames[] = {i18n( "DESY (Germany)" ), i18n( "FNAL (U.S.A.)" ), i18n( "IHEP (Russia)" ), i18n( "Durham U (U.K.)" ), i18n( "SLAC (U.S.A.)" ), i18n( "YITP (Japan)" ), i18n( "LIPI (Indonesia)" )};
    const QString WebQueryWizardSpiresHep::mirrorURLs[] = {"http://www-library.desy.de/cgi-bin/spiface", "http://www-spires.fnal.gov/spires", "http://usparc.ihep.su/spires", "http://www-spires.dur.ac.uk/spires", "http://www.slac.stanford.edu/spires", "http://www.yukawa.kyoto-u.ac.jp/spires", "http://www.spires.lipi.go.id/spires"};

    WebQuerySpiresHep::WebQuerySpiresHep( QWidget* parent, const char* name ): WebQuery( parent, name )
    {
        m_wizard = new WebQueryWizardSpiresHep( title(), parent, name );
    }

    WebQuerySpiresHep::~WebQuerySpiresHep()
    {
        delete m_wizard;
    }

    BibTeX::File* WebQuerySpiresHep::query( )
    {
        if ( m_wizard->exec() == QDialog::Accepted )
            return m_wizard->result();
        else
            return NULL;
    }

    int WebQuerySpiresHep::uniqueId()
    {
        return 0x03b11fe6;
    }

    QString WebQuerySpiresHep::title()
    {
        return i18n( "SPIRES-HEP" );
    }

    WebQueryWizardSpiresHep::WebQueryWizardSpiresHep( const QString& caption, QWidget* parent, const char* name ): WebQueryWizard( caption, i18n( "SPIRES-HEP Search" ), "http://www.slac.stanford.edu/spires/", TRUE, FALSE, parent, name )
    {
        for ( unsigned int i = 0; i < sizeof( mirrorNames ) / sizeof( mirrorNames[0] ); ++i )
            m_comboBoxMirrors->insertItem( mirrorNames[i] );
    }

    WebQueryWizardSpiresHep::~WebQueryWizardSpiresHep()
    {
// nothing
    }

    void WebQueryWizardSpiresHep::startSearch()
    {
        setEnabled( FALSE );
        QApplication::setOverrideCursor( Qt::waitCursor );
        m_listViewResults->clear();

        KURL url = KURL( QString( "%2/find/hep/www?rawcmd=%1&FORMAT=WWWBRIEFBIBTEX&SEQUENCE=" ).arg( m_lineEditQuery->text().replace( "%", "%25" ).replace( " ", "+" ).replace("?","%3F" ).replace("&","%26" ) ).arg( mirrorURLs[m_comboBoxMirrors->currentItem()] ) );
        QString tmpFile;
        if ( KIO::NetAccess::download( url, tmpFile, NULL ) )
        {
            BibTeX::FileImporterBibTeX importer( FALSE );
            importer.setIgnoreComments( TRUE );
            QFile inputFile( tmpFile );
            inputFile.open( IO_ReadOnly );
            BibTeX::File *tmpBibFile = importer.load( &inputFile );
            inputFile.close();
            KIO::NetAccess::removeTempFile( tmpFile );

            for ( BibTeX::File::ElementList::iterator it = tmpBibFile->begin(); it != tmpBibFile->end(); ++it )
            {
                BibTeX::Entry *entry = dynamic_cast<BibTeX::Entry*>( *it );
                if ( entry != NULL )
                    new ResultsListViewItem( m_listViewResults, new BibTeX::Entry( entry ) );
            }

            delete tmpBibFile;
        }
        else
            KMessageBox::error( this, KIO::NetAccess::lastErrorString() );

        setEnabled( TRUE );
        QApplication::restoreOverrideCursor();
    }

}
