/***************************************************************************
 *   Copyright (C) 2003 by Mattia Merzi                                    *
 *   ottobit@ferrara.linux.it                                              *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#include <qvariant.h>
#include <qbuttongroup.h>
#include <qcheckbox.h>
#include <qframe.h>
#include <qlabel.h>
#include <qlistbox.h>
#include <qpushbutton.h>
#include <qradiobutton.h>
#include <qspinbox.h>
#include <qlayout.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
#include <qimage.h>
#include <qpixmap.h>
#include <qmessagebox.h>

#include <kprocess.h>
#include <kstandarddirs.h>
#include <kdebug.h>

#include <libkbluetooth/inquiry.h>
#include <libkbluetooth/namerequest.h>

#include "KBlueLockConfig.h"
#include "KBlueLockConfigHandlers.cpp"

#include "klock_icons.h"

using namespace KBluetooth;

/*
 *  Constructs a KBlueLockConfig as a child of 'parent', with the
 *  name 'name' and widget flags set to 'f'.
 *
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  TRUE to construct a modal dialog.
 */
KBlueLockConfig::KBlueLockConfig( QWidget* parent, const char* name, bool modal, WFlags fl )
    : QDialog( parent, name, modal, fl )
,
      image0( (const char **) image0_data ),
      image1( (const char **) image1_data ),
      image2( (const char **) image2_data )
{
    if ( !name )
	setName( "KBlueLockConfig" );

    buttongroup_bottom_buttons =
      new QButtonGroup( this, "buttongroup_bottom_buttons" );
    buttongroup_bottom_buttons->setGeometry( QRect( 10, 424, 560, 61 ) );

    line2 = new QFrame( buttongroup_bottom_buttons, "line2" );
    line2->setGeometry( QRect( 131, 7, 20, 47 ) );
    line2->setFrameShape( QFrame::VLine );
    line2->setFrameShadow( QFrame::Sunken );
    line2->setFrameShape( QFrame::VLine );

    pushbutton_exit =
      new QPushButton( buttongroup_bottom_buttons, "pushbutton_exit" );
    pushbutton_exit->setGeometry( QRect( 430, 10, 110, 41 ) );
    pushbutton_save =
      new QPushButton( buttongroup_bottom_buttons, "pushbutton_save" );
    pushbutton_save->setGeometry( QRect( 310, 10, 110, 41 ) );
    pushbutton_test =
      new QPushButton( buttongroup_bottom_buttons, "pushbutton_test" );
    pushbutton_test->setGeometry( QRect( 190, 10, 110, 41 ) );
    pushbutton_default_screenlock = new QPushButton(
      buttongroup_bottom_buttons, "pushbutton_default_screenlock" );
    pushbutton_default_screenlock->setGeometry( QRect( 11, 10, 120, 41 ) );
    buttonGroup_main = new QButtonGroup( this, "buttonGroup_main" );
    buttonGroup_main->setGeometry( QRect( 10, 10, 560, 410 ) );
    button_group_devices_found =
      new QButtonGroup( buttonGroup_main, "button_group_devices_found" );
    button_group_devices_found->setGeometry( QRect( 310, 10, 231, 180 ) );
    listbox_devices_found =
      new QListBox( button_group_devices_found, "listbox_devices_found" );
    listbox_devices_found->setGeometry( QRect( 10, 20, 211, 150 ) );
    listbox_devices_found->setSelectionMode( QListBox::Single );
    pushbutton_scan = new QPushButton( buttonGroup_main, "pushbutton_scan" );
    pushbutton_scan->setGeometry( QRect( 310, 200, 120, 40 ) );
    pushbutton_query = new QPushButton( buttonGroup_main, "pushbutton_query" );
    pushbutton_query->setGeometry( QRect( 440, 200, 100, 40 ) );
    button_group_trusted_devices =
      new QButtonGroup( buttonGroup_main, "button_group_trusted_devices" );
    button_group_trusted_devices->setGeometry( QRect( 20, 10, 231, 230 ) );
    listbox_trusted_devices =
      new QListBox( button_group_trusted_devices, "listbox_trusted_devices" );
    listbox_trusted_devices->setGeometry( QRect( 10, 20, 211, 200 ) );
    listbox_trusted_devices->setSelectionMode( QListBox::Single );
    buttongroup_scan_options =
      new QButtonGroup( buttonGroup_main, "buttongroup_scan_options" );
    buttongroup_scan_options->setGeometry( QRect( 20, 260, 230, 130 ) );
    radiobutton_timed =
      new QRadioButton( buttongroup_scan_options, "radiobutton_timed" );
    radiobutton_timed->setGeometry( QRect( 10, 60, 104, 21 ) );
    radiobutton_continuous =
      new QRadioButton( buttongroup_scan_options, "radiobutton_continuous" );
    radiobutton_continuous->setGeometry( QRect( 10, 30, 130, 21 ) );
    label_interval = new QLabel( buttongroup_scan_options, "label_interval" );
    label_interval->setGeometry( QRect( 30/*20*/, 90, 129, 20 ) );
    spin_interval = new QSpinBox( buttongroup_scan_options, "spin_interval" );
    spin_interval->setGeometry( QRect( 150, 89, 70, 23 ) );
    spin_interval->setMinValue(0);
    spin_interval->setMaxValue(10000);
    buttongroup_authentication =
      new QButtonGroup( buttonGroup_main, "buttongroup_authentication" );
    buttongroup_authentication->setGeometry( QRect( 310, 260, 230, 130 ) );
    check_validate_name =
      new QCheckBox( buttongroup_authentication, "check_validate_name" );
    check_validate_name->setGeometry( QRect( 10, 60, 120, 21 ) );
    check_validate_bdaddr =
      new QCheckBox( buttongroup_authentication, "check_validate_bdaddr" );
    check_validate_bdaddr->setGeometry( QRect( 10, 30, 130, 21 ) );
    check_validate_bdaddr->setChecked( TRUE );
    check_validate_device_type =
      new QCheckBox( buttongroup_authentication, "check_validate_device_type" );
    check_validate_device_type->setGeometry( QRect( 10, 89, 180/*150*/, 21 ) );
    line1 = new QFrame( buttonGroup_main, "line1" );
    line1->setGeometry( QRect( 10, 240, 540, 20 ) );
    line1->setFrameShape( QFrame::HLine );
    line1->setFrameShadow( QFrame::Sunken );
    line1->setFrameShape( QFrame::HLine );
    pushbutton_trash = new QPushButton( buttonGroup_main, "pushbutton_trash" );
    pushbutton_trash->setGeometry( QRect( 260, 170, 41, 60 ) );
    pushbutton_trash->setPixmap( image0 );
    pushbutton_add = new QPushButton( buttonGroup_main, "pushbutton_add" );
    pushbutton_add->setGeometry( QRect( 260, 100, 41, 60 ) );
    pushbutton_add->setPixmap( image1 );
    pushbutton_add_all =
      new QPushButton( buttonGroup_main, "pushbutton_add_all" );
    pushbutton_add_all->setGeometry( QRect( 260, 30, 41, 60 ) );
    pushbutton_add_all->setPixmap( image2 );
    languageChange();
    setFixedSize( QSize(580, 494).expandedTo(minimumSizeHint()) );

/* non-GUI initialization section */
    config = kbluelockrc::getDefaultRC();
    setFormValues();
    scan_addrs = new QStringList();
    scan_names = new QStringList();
    scan_types = new QStringList();
    inquiry = new Inquiry(NULL, this);
    scanning = false;
    proc_ok = true;
/* non-GUI initialization section */

    connect( pushbutton_add, SIGNAL(clicked()),
             this, SLOT(pushbutton_add_clicked()));
    connect( pushbutton_add_all, SIGNAL(clicked()),
             this, SLOT(pushbutton_add_all_clicked()));
    connect( pushbutton_trash, SIGNAL(clicked()),
             this, SLOT(pushbutton_trash_clicked()));
    connect( pushbutton_exit, SIGNAL(clicked()),
             this, SLOT(pushbutton_exit_clicked()));
    connect( pushbutton_save, SIGNAL(clicked()),
             this, SLOT(pushbutton_save_clicked()));
    connect( pushbutton_test, SIGNAL(clicked()),
             this, SLOT(pushbutton_test_clicked()));
    connect( pushbutton_default_screenlock, SIGNAL(clicked()),
             this, SLOT(pushbutton_default_screenlock_clicked()));
    connect( pushbutton_scan, SIGNAL(clicked()),
             this, SLOT(pushbutton_scan_clicked()));
    connect( pushbutton_query, SIGNAL(clicked()),
             this, SLOT(pushbutton_query_clicked()));
    connect( check_validate_name, SIGNAL(toggled( bool )),
             this, SLOT(check_validate_name_toggled( bool )));
    connect( check_validate_bdaddr, SIGNAL(toggled( bool )),
             this, SLOT(check_validate_bdaddr_toggled( bool )));
    connect( check_validate_device_type, SIGNAL(toggled( bool )),
             this, SLOT(check_validate_device_type_toggled( bool )));
    connect( spin_interval, SIGNAL(valueChanged( int )),
             this, SLOT(spin_interval_value_changed( int )));
    connect( radiobutton_timed, SIGNAL(toggled( bool )),
             this, SLOT(radiobutton_timed_toggled( bool )));
    connect( radiobutton_continuous, SIGNAL(toggled( bool )),
             this, SLOT(radiobutton_continuous_toggled( bool )));
    connect(inquiry,
        SIGNAL(neighbourFound(const KBluetooth::DeviceAddress&, int)),
        this, SLOT(slotInquiryDeviceFound(const KBluetooth::DeviceAddress&)));
    connect(inquiry, SIGNAL(finnished()),
        this, SLOT(slotInquiryFinnished()));

// test section
/*    scan_addrs->append("abcd1234");
    scan_addrs->append("xxx123");
    scan_addrs->append("oooiiiuuu");
    scan_names->append("mattia");
    scan_names->append("pippo");
    scan_names->append("mario");
    scan_types->append("headset");
    scan_types->append("usb");
    scan_types->append("pcmcia");
kdDebug() << "first scan structs sizes: " << scan_addrs->size() << endl;
    listbox_devices_found->insertItem("abcd1234");
    listbox_devices_found->insertItem("xxx123");
    listbox_devices_found->insertItem("oooiiiuuu"); */
// test section
    kdDebug() << "Constructor: Ok." << endl;
}

void KBlueLockConfig::setFormValues() {
  if (config->getScanInterval() == 0)
    radiobutton_continuous->setChecked(true);
  else {
    radiobutton_timed->setChecked(true);
    spin_interval->setValue(config->getScanInterval());
  }
  old_spin_interval_value = config->getScanInterval();

  check_validate_bdaddr->setChecked(config->getValidateBDADDR());
  check_validate_name->setChecked(config->getValidateName());
  check_validate_device_type->setChecked(config->getValidateDeviceType());
  listbox_trusted_devices->clear();
  QString* tmp = new QString();
  QStringList::Iterator d_it;
  QStringList::Iterator n_it;
  d_it = config->getDeviceAddresses()->begin();
  n_it = config->getDeviceNames()->begin();
  for (;(d_it != config->getDeviceAddresses()->end())&&
         n_it != config->getDeviceNames()->end(); ) {
    *tmp += *(d_it++);
    *tmp += " : ";
    *tmp += *(n_it++);
    listbox_trusted_devices->insertItem(*tmp);
    tmp = new QString();
  }
}

void KBlueLockConfig::closeEvent(QCloseEvent*){
  quit();
}

void KBlueLockConfig::quit() {
  kapp->quit();
  delete this;
}

void KBlueLockConfig::save_changes() {
  config->write();
}

/*
 *  Destroys the object and frees any allocated resources
 */
KBlueLockConfig::~KBlueLockConfig()
{
    // no need to delete child widgets, Qt does it all for us
}

/*
 *  Sets the strings of the subwidgets using the current
 *  language.
 */
void KBlueLockConfig::languageChange()
{
    setCaption( tr( "KDE-Bluetooth Screen Lock Configuration" ) );
    buttongroup_bottom_buttons->setTitle( QString::null );
    pushbutton_exit->setText( tr( "Exit" ) );
    pushbutton_save->setText( tr( "Save" ) );
    pushbutton_test->setText( tr( "Test" ) );
    pushbutton_default_screenlock->setText( tr( "Set as default lock" ) );
    buttonGroup_main->setTitle( QString::null );
    button_group_devices_found->setTitle( tr( "Devices Found" ) );
    pushbutton_scan->setText( tr( "Scan for Devices" ) );
    pushbutton_query->setText( tr( "Query Names" ) );
    button_group_trusted_devices->setTitle( tr( "Trusted Devices" ) );
    buttongroup_scan_options->setTitle( tr( "Scan Options" ) );
    radiobutton_timed->setText( tr( "Timed Scan" ) );
    radiobutton_continuous->setText( tr( "Continuous Scan" ) );
    label_interval->setText( tr( "Scan Interval:" ) );
    buttongroup_authentication->setTitle( tr( "Authentication Options" ) );
    check_validate_name->setText( tr( "Validate Name" ) );
    check_validate_bdaddr->setText( tr( "Validate BDAddr" ) );
    check_validate_device_type->setText( tr( "Validate Device Type" ) );
    pushbutton_trash->setText( QString::null );
    pushbutton_add->setText( QString::null );
    pushbutton_add_all->setText( QString::null );
}

#include "KBlueLockConfig.moc"
