//-*-c++-*-
/***************************************************************************
 *   Copyright (C) 2003 by Fred Schaettgen                                 *
 *   kbluetoothd@schaettgen.de                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#include <qlayout.h>

#include <klocale.h>
#include <kconfig.h>
#include <kapplication.h>
#include <kglobal.h>
#include <kjanuswidget.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qvbox.h>
#include <dcopclient.h>
#include "pairedtab.h"

#include "kcm_btpaired.h"

kcm_btpaired::kcm_btpaired(QWidget *parent, const char *name)
    : KCModule(parent, name)
{
    QVBoxLayout* mainLayout = new QVBoxLayout(this);
    if (true /*isroot*/) {
        tabContainer = new KJanusWidget(this, "tabcontainer", KJanusWidget::Tabbed);
        mainLayout->addWidget(tabContainer);

        QVBox* serviceBox = tabContainer->addVBoxPage(QString("Paired Devices"));
        pairedTab = new PairedTab(serviceBox, "pairedtab");
        connect(pairedTab, SIGNAL(dirty()), this, SLOT(configChanged()));

        load();

        KConfig* config = instance()->config();
        config->setGroup("kcm_btpaired_global");
        tabContainer->showPage(config->readNumEntry("currentTab", 0));
    }
    else {
        QLabel *label = new QLabel("<p>You can use this module in administrator mode only</p>",
            this);
        mainLayout->addWidget(label);
    }
};


kcm_btpaired::~kcm_btpaired()
{
    KConfig* config = instance()->config();
    config->setGroup("kcm_btpaired_global");
    config->writeEntry("currentTab", tabContainer->activePageIndex());    
}

void kcm_btpaired::load()
{
}


void kcm_btpaired::defaults()
{
    if (pairedTab) pairedTab->defaults();
    emit changed(true);
}


void kcm_btpaired::save()
{
    if (pairedTab) pairedTab->apply();
    emit changed(true);
}


int kcm_btpaired::buttons()
{
    return KCModule::Default|KCModule::Apply|KCModule::Help;
}


void kcm_btpaired::configChanged()
{
    // insert your saving code here...
    emit changed(true);
}


QString kcm_btpaired::quickHelp() const
{
    return i18n("<h1>BtPaired</h1>\
With this module you can manage the list of paired Bluetooth Devices.");
}


extern "C"
{
    KCModule *create_btpaired(QWidget *parent, const char */*name*/)
    {
        KGlobal::locale()->insertCatalogue("btpaired");
        return new kcm_btpaired(parent, "btpaired");
    }
}

#include "kcm_btpaired.moc"
