/***************************************************************************
 *   Copyright (C) 2004, 2005, 2006 Thomas Nagy                            *
 *   Thomas Nagy <tnagyemail-com@yahoo.fr>                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation (see COPYING)            *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 ***************************************************************************/

#include <qfontmetrics.h>
#include <qstring.h>
#include <qpainter.h>

#include <kiconloader.h>

#include "DDataControl.h"
#include "DCanvasFlag.h"
#include "DCanvasItem.h"

DCanvasFlag::DCanvasFlag(QCanvas* canvas, DCanvasItem* parent, int flag) : QCanvasRectangle(canvas)
{
	m_flagidx = flag;
	m_parent = parent;

	switch (m_flagidx)
	{
		case DDataControl::e_warning:
			m_pixmap = BarIcon("messagebox_warning");
			break;
		case DDataControl::e_good:
			m_pixmap = BarIcon("bookmark");
			break;
		case DDataControl::e_idea:
			m_pixmap = BarIcon("ktip");
			break;
		case DDataControl::e_work:
			m_pixmap = BarIcon("package_settings");
			break;
		case DDataControl::e_clarify:
			m_pixmap = BarIcon("xmag");
			break;
		case DDataControl::e_question:
			m_pixmap = BarIcon("help");
			break;
		case DDataControl::e_trash:
			m_pixmap = BarIcon("trashcan_empty");
			break;
		case DDataControl::e_meeting:
			m_pixmap = BarIcon("penguin");
			break;
		case DDataControl::e_trouble:
			m_pixmap = BarIcon("ksplash");
			break;
		default:
			m_pixmap = BarIcon("void");
			break;
	}

	setSize( m_pixmap.width(), m_pixmap.height() );
	show();
}

DCanvasFlag::~DCanvasFlag()
{
	hide();
}

void DCanvasFlag::drawShape(QPainter &p)
{
	p.drawPixmap( rect(), m_pixmap );
}

