#ifndef __KGTK_H__
#define __KGTK_H__

/************************************************************************
 *
 * All dialogs opened are created and used modal.
 *
 ************************************************************************
 * (C) Craig Drummond, 2006
 ************************************************************************
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 ************************************************************************/

#include <gtk/gtk.h>
#include <glib.h>

G_BEGIN_DECLS

/*
 * Intitialise the library. Checks to see if KDE_FULL_SESSION set, if so
 * tries to start KDialogD
 *
 * If this fails, all the calls below will use Gtk dialogs.
 *
 */

gboolean      kgtk_init();

/*
 * Close down the connection to kdialogd.
 *
 */
void          kgtk_exit();

#ifndef KGTK_GTK
/*
 * Open a "File Open" dialog to select 1 file.
 *
 * Filter has the following format:
 *    <pattern>|name
 *
 * e.g.
 *     const char *filter="*|All Files"
 *                        "\n*.jpg *.jpeg|JPEG Images"
 *
 * Returned value *must* be g_free()'d
 */
gchar *  kgtk_get_open_filename(GtkWidget *parent, const char *title,
                                const char *dir, const char *filter,
                                GCallback previewCallback);

/*
 * Open a "File Open" dialog to select multiple files.
 *
 * Returned value *must* be g_free()'d
 */
GSList * kgtk_get_open_filenames(GtkWidget *parent, const char *title,
                                 const char *dir, const char *filter,
                                 GCallback previewCallback);

/*
 * Open a "File Save" dialog to select 1 file.
 *
 * Returned value *must* be g_free()'d
 */
gchar *  kgtk_get_save_filename(GtkWidget *parent, const char *title,
                                const char *dir, const char *filter,
                                GCallback previewCallback);

/*
 * Open a Folder selection dialog.
 *
 * Returned value *must* be g_free()'d
 */
gchar * kgtk_get_folder(GtkWidget *parent, const char *title, const char *dir, gboolean create);

/*
 * Open a Color selection dialog.
 *
 * NOTE: Currently KDE does not support opacity in its colour dialog, so do not
 *       use this funciton if the user is to be allow to change the opacity.
 *
 */
gboolean kgtk_get_color(GtkWidget *parent, const char *title, GdkColor *color);

/*
 * Open a Font selection dialog.
 *
 * Returned value *must* be g_free()'d
 */
gchar * kgtk_get_fontname(GtkWidget *parent, const char *title, const char *current);

/*
 * Initialise a GtkColorButton. This function will override the "clicked"
 * callback, in order to produce a KDE color dialog.
 *
 * NOTE: Currently KDE does not support opacity in its colour dialog, so do not
 *       use this funciton if the user is to be allow to change the opacity.
 */
void     kgtk_init_color_picker(GtkWidget *picker);

/*
 * Initialise a GtkFontButton. This function will override the "clicked"
 * callback, in order to produce a KDE font dialog.
 */
void     kgtk_init_font_picker(GtkWidget *picker);

/*
 * Initialise a GtkFileChooserButton. This function will override the "clicked"
 * callback, in order to produce a KDE color dialog.
 */
void     kgtk_init_file_picker(GtkWidget *picker);

#else
gint     kgtk_dialog_run(GtkDialog *dialog);
gboolean kgt_handled_dialog(GtkWidget *widget);
#endif

G_END_DECLS

#endif
