/***************************************************************************
                          KickPimCard.cpp  -  description
                             -------------------
    begin                : Don Okt 17 2002
    copyright            : (C) 2002 by Bert Speckels
    email                : bert@speckels.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kickpimcard.h"

#include "../kickpim.h"

#include "kpinfo.h"

#include <qstringlist.h>
#include <qlayout.h>
#include <qcursor.h>
#include <qlabel.h>
#include <qtoolbutton.h>
#include <qdesktopwidget.h>
#include <qapplication.h> 

#include <kpopupmenu.h>
#include <ktextbrowser.h>
#include <kglobalsettings.h>
#include <klocale.h>
#include <kmimetype.h>
#include <krun.h>

#include "kickpiminfodialog.h"

#include "../kpcontact.h"

using namespace std;

KickPimCard::KickPimCard(QWidget *parent, const char *name, WFlags/* f */)
        : QFrame(parent,name, Qt::WType_Popup)
{
  FUNC_CALL(KickPimCard::KickPimCard)
  
  setFrameStyle(QFrame::Box | QFrame::Plain );

  QLabel*  label=0;
  QWidget* titleWidget=0;

  // fonts
  QFont contentfont = this->font();
  contentfont.setPixelSize(12);
  contentfont.setWeight(QFont::Bold);
  setFont(contentfont);

  QFont buttonfont = this->font();
  buttonfont.setPixelSize(10);
  buttonfont.setWeight(QFont::Normal);

  QFont smallfont = this->font();
  smallfont.setPixelSize(10);
  smallfont.setWeight(QFont::Normal);
  
  QFont titlefont = this->font();
  titlefont.setPixelSize(12);
  titlefont.setWeight(QFont::Bold);

  m_button [ADDRESS]  = new QLabel ( i18n("Address"),this,"Address");
  m_content[ADDRESS]  = new KMultiContentWidget ( this,"AddressContent");  
  m_button [BIRTHDAY] = new QLabel (i18n("Birthday"),this,"Birthday");
  m_content[BIRTHDAY] = new KMultiContentWidget (this,"BirthdayContent");
  m_button [EMAIL]    = new QLabel ( i18n("Email"),this,"Email");
  m_content[EMAIL]    = new KMultiContentWidget ( this,"EmailContent");
  m_button [PHONE]    = new QLabel ( i18n("Phone"),this,"Phone");
  m_content[PHONE]    = new KMultiContentWidget ( this,"PhoneContent");

  for (int i=0;i<CONTENT_MAX;i++)
  {
    m_content[i]->setLabelWidget(m_button[i]);    
    
    m_button[i]->setFont(buttonfont);
    m_button[i]->setAlignment(Qt::AlignBottom);

    m_content[i]->setFont(contentfont);
    m_content[i]->setAlignment(Qt::AlignTop);

    m_content[i]->setMinimumWidth(100);
    m_button[i]->setMinimumWidth(100);

//    m_content[i]->setPaletteBackgroundColor( QColor(128,128,128) );
//    m_button[i]->setPaletteBackgroundColor( QColor(128,128,196) );

    connect(m_content[i],SIGNAL(contentChanged(const QString&)),this,SLOT(onContentChanged(const QString&)));

  }
    
  m_note = new KTextBrowser(this,"Note");
  m_note->setFixedHeight(80);
  m_note->setBaseSize(300,80);
  m_note->setFrameStyle(QFrame::Box | QFrame::Plain );
  m_note->setLineWidth(1);
  m_note->setFont(smallfont);

  // layout

  QBoxLayout* root_layout = new QVBoxLayout(this);
  root_layout->setSpacing(4);
  root_layout->setMargin(4);

    titleWidget = new QWidget(this);
    titleWidget->setPaletteBackgroundColor(KGlobalSettings::activeTitleColor());
    titleWidget->setPaletteForegroundColor(KGlobalSettings::activeTextColor());
    root_layout->addWidget(titleWidget);

      QBoxLayout* title_layout = new QHBoxLayout(titleWidget);
      title_layout->setMargin(4);

        m_name = new KMultiContentWidget(titleWidget,"Name");
        m_name->setFont(titlefont);
        title_layout->addWidget(m_name);        

    QBoxLayout* contentLayout = new QVBoxLayout();
    contentLayout->setMargin(4);
    root_layout->addLayout(contentLayout);
        
    QBoxLayout* col_layout = new QHBoxLayout();
    col_layout->setSpacing(10);
    col_layout->setMargin(0);
    contentLayout->addLayout(col_layout);

      QBoxLayout* left_layout = new QVBoxLayout();
      left_layout->setSpacing(0);
      col_layout->addLayout(left_layout);

        left_layout->addWidget( m_button  [ADDRESS] );
        left_layout->addWidget( m_content [ADDRESS] );
        left_layout->addStretch(1);

      //col_layout->addStretch(0);
        
      QBoxLayout* right_layout = new QVBoxLayout();
      right_layout->setSpacing(0);
      col_layout->addLayout(right_layout);      

        right_layout->addWidget( m_button  [PHONE]   );
        right_layout->addWidget( m_content [PHONE]   );
        right_layout->addStretch(1);
        right_layout->addWidget( m_button  [BIRTHDAY] );
        right_layout->addWidget( m_content [BIRTHDAY] );


      contentLayout->addWidget( m_button  [EMAIL]   );
      contentLayout->addWidget( m_content [EMAIL]   );
      contentLayout->addSpacing(5);
      
      contentLayout->addWidget( m_note );


  connect(m_content[EMAIL],SIGNAL(mouseButtonClicked()),
          this,            SLOT  (mailContentClicked()) );
  connect(m_name,          SIGNAL(mouseButtonClicked()),
          this,            SLOT  (nameContentClicked()) );

  QFont helpfont = buttonfont;

  QHBoxLayout* toolBarLayout = new QHBoxLayout();
  root_layout->addLayout(toolBarLayout);

    /*
    QToolButton* menuButton = new QToolButton(this);
    menuButton->setPixmap( QPixmap( KickPIM::rep()->dirOfIcons() + "hi12-kickpim-cardmenu.png") );
    menuButton->setFixedSize(20,18);
    toolBarLayout->addWidget(menuButton);
    */

    label = new QLabel(this,"help");
    label->setFont(helpfont);
    label->setText(i18n("Use left and right mouse button for actions and selections!"));
    label->setAlignment(Qt::AlignHCenter | Qt::AlignVCenter);
    toolBarLayout->addWidget(label);
  
        
  root_layout->setStretchFactor(titleWidget,0);
  contentLayout->setStretchFactor(col_layout,1);

  updateGeometry();
}

KickPimCard::~KickPimCard()
{
  FUNC_CALL(KickPimCard::~KickPimCard);
}


void KickPimCard::setContact(KPContact* contact)
{
  m_contact = contact;
  
  QString text="";
  
  setNameContent     ();
  setAddressContent  ();
  setEmailContent    ();
  setPhoneContent    ();
  setBirthdayContent ();

  m_note->setText( contact->note() );

  recalcSize();
}


void KickPimCard::setNameContent()
{
  m_name->clearContent();
  if (!m_contact) return;

  QStringMap names = m_contact->names();
  
  QString org   = names["organizationName"];
  QString nick  = names["nickName"];
  QString job   = "";//entry.role();         TODO: reinsert
  KURL url;
  // KURL url      = m_contact->webpageURLs();
  

  // name
  QString text=KickPIM::rep()->displayName(m_contact);
  
  // job title
  if (!job.isEmpty())  text+=" ("+job+")";

  // organisation
  if (!org.isEmpty())
  {
      if (!text.isEmpty()) text+="; ";
      text+=org;
  }  
  if (!nick.isEmpty()) text+=" ["+nick+"]";

  // webpage?
  m_webpage = url.url();
  if (!m_webpage.isEmpty()) m_name->setCursor( QCursor(Qt::PointingHandCursor) );
  else                      m_name->setCursor( QCursor(Qt::ArrowCursor) );
  
  m_name->addContent("1",text,true);

}

void KickPimCard::setEmailContent()
{
  m_content[EMAIL]->clearContent();
  if (!m_contact) return;

  QString email;
  QStringList mailList = m_contact->emailAddresses();
    // mailList.sort();
  QStringList::iterator mailItor = mailList.begin();
  int count=0;
  QString label = i18n("Email");  
  
  if (mailList.count()>1)
  {
    QString amountString = "/"+QString::number(mailList.count());      
    while (mailItor != mailList.end())
    {
      email = QString(*mailItor);
      m_content[EMAIL]->addContent(label+" "+QString::number(count+1)+amountString,email, false);
      count++;
      mailItor++;
    }
    m_content[EMAIL]->selectContent(label+" 1"+amountString);
  }
  else
  {
    email = QString(*mailItor);
    m_content[EMAIL]->setText(email);
  }
  
  if (mailList.count()>0) m_content[EMAIL]->setCursor( QCursor(Qt::PointingHandCursor) );
  else                    m_content[EMAIL]->setCursor( QCursor(Qt::ArrowCursor) );

}


void KickPimCard::setPhoneContent()
{
  m_content[PHONE]->clearContent();
  if (!m_contact) return;

  bool prefFound = false;
  bool homeFound = false;
  QStringMap phoneMap = m_contact->phoneNumbers();
  QStringMap::iterator itor = phoneMap.begin();  
  int count=0;
  while (itor != phoneMap.end())
  {
    m_content[PHONE]->addContent( i18n(itor.key()) ,itor.data(),count==0);
    prefFound = prefFound || (itor.key()=="Preferred Number");
    homeFound = homeFound || (itor.key()=="home phone");
    ++count;
    ++itor;
  }
  if (prefFound)      m_content[PHONE]->selectContent( i18n("Preferred Number") );
  else if (homeFound) m_content[PHONE]->selectContent( i18n("home phone") );
  else                m_content[PHONE]->selectContent( i18n(phoneMap.begin().key()) );
};


void KickPimCard::setAddressContent()
{
  m_content[ADDRESS]->clearContent();
  if (!m_contact) return;

  QAddressMap addrMap = m_contact->addresses();
  KPContactAddress address;

  bool prefFound=false;
  bool homeFound=false;
  QAddressMap::iterator itor = addrMap.begin();
  int count=0;
  while (itor != addrMap.end())
  {
    address = itor.data();
    m_content[ADDRESS]->addContent( i18n(itor.key()),address.formattedAddress("\n",true),count==0);
    prefFound = prefFound || (itor.key()=="Preferred Address");
    homeFound = homeFound || (itor.key()=="Home Address");
    ++count;
    ++itor;
  }
  if (prefFound)      m_content[ADDRESS]->selectContent( i18n("Preferred Address") );
  else if (homeFound) m_content[ADDRESS]->selectContent( i18n("Home Address") );
  else                m_content[ADDRESS]->selectContent( i18n(addrMap.begin().key()) );
}


QString KickPimCard::getAddressType(int)
{
  QString text="";
/*
  if (type && KABC::Address::Dom)    text+="Dom<br>";
  if (type && KABC::Address::Intl)   text+="Intl<br>";
  if (type && KABC::Address::Postal) text+="Postal<br>";
  if (type && KABC::Address::Parcel) text+="Parcel<br>";
  if (type && KABC::Address::Home)   text+="Home<br>";
  if (type && KABC::Address::Work)   text+="Work<br>";
  if (type && KABC::Address::Pref)   text+="Pref<br>";
*/
  return text;
};

void KickPimCard::setBirthdayContent ()
{
  m_content[BIRTHDAY]->clearContent();
  if (!m_contact) return;

  bool first = true;
      
  QDate birthday = m_contact->birthday();
  if( birthday.isValid() )
  {
      QString text="";
      QDate today = QDate().currentDate();

      int year = today.year();
      if( today.dayOfYear() < birthday.dayOfYear() )  year--;
      int age = year - birthday.year();

      QString birthdate = birthday.toString(Qt::LocalDate);
      text+=birthdate+", ";
      text+=i18n("age: %n year","age: %n years",age);
      m_content[BIRTHDAY]->addContent(i18n("Birthday"),text,false);

      m_content[BIRTHDAY]->selectContent(i18n("Birthday"));
      first = false;
  }

  QDate anniversary = m_contact->anniversary();
  if( anniversary.isValid() )
  {
      QString text="";
      QDate today = QDate().currentDate();

      int year = today.year();
      if( today.dayOfYear() < anniversary.dayOfYear() )  year--;
      int age = year - anniversary.year();

      QString annidate = anniversary.toString(Qt::LocalDate);
      text+=annidate+", ";

      text+=i18n("%n year","%n years",age);
      m_content[BIRTHDAY]->addContent(i18n("Anniversary"),text,false);
      
      if (first) m_content[BIRTHDAY]->selectContent(i18n("Anniversary"));
  }
}


void KickPimCard::nameContentClicked ()
{
  if (m_webpage.isEmpty()) return;
    
  close();

  cout << "Visit " << m_webpage << endl;
  KURL url("http://"+m_webpage);
  new KRun(url);
}


void KickPimCard::mailContentClicked ()
{
  QString address = m_content[EMAIL]->text();
  if (address.isEmpty()) return;
  close();

  QStringMap names = m_contact->names();
  QString email = names["givenName"] + " " + names["familyName"]+" <"+address+">";
  LogService::logInfo( LogService::CAT_MAIL, "Mail to " + email );
  KURL url("mailto:"+email);
  new KRun(url);
}

void KickPimCard::onContentChanged(const QString&)
{
  cout << "KickPimCard::onContentChanged" << endl;  
  recalcSize();
}

void KickPimCard::recalcSize()
{
  if (layout()) layout()->activate();
  resize(sizeHint());
}

void KickPimCard::show()
{
  FUNC_CALL(KickPimCard::show);
  if (KickPIM::opt()->isInfoActive(KickPimOptions::INFO_CARD))
  {
    KickPIM::opt()->deactivateInfo(KickPimOptions::INFO_CARD);    
    KickPimInfoDialog dlg;
    dlg.setInfoText( i18n(infoCardView) );
    dlg.setPicture( QPixmap( KickPIM::rep()->dirOfInfo() + "info-kickpim-card.png") );
    dlg.exec();
  }
  
  QFrame::show();
}
