/***************************************************************************
                          KickPimContactChangeDialog.cpp  -  description
                             -------------------
    begin                : Die Nov 5 2002
    copyright            : (C) 2002 by Bert Speckels
    email                : bert.speckels@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kickpimcontactchangedialog.h"
#include <keditlistbox.h>
#include <qtextedit.h>
#include <qcheckbox.h>

KickPimContactChangeDialog::KickPimContactChangeDialog(QWidget *parent, const char *name ) : KickPimContactChangeDlg(parent,name)
{
  connect((QObject*)RejectButton,SIGNAL(pressed()),this,SLOT(reject()));
  connect((QObject*)AcceptButton,SIGNAL(pressed()),this,SLOT(accept()));
  NoteEdit->setFocus();
}

KickPimContactChangeDialog::~KickPimContactChangeDialog()
{
}

void KickPimContactChangeDialog::setNoteList( QStringList noteList )
{
  NoteEdit->setText( noteList.join("\n---\n") );
}

void KickPimContactChangeDialog::setCategories( QStringList catList )
{
  CatEdit->insertStringList( catList );
}

QString KickPimContactChangeDialog::note()
{
  return NoteEdit->text();
}

QStringList KickPimContactChangeDialog::categories()
{
  return CatEdit->items(); 
}

bool KickPimContactChangeDialog::changeNotes() {
  return NoteEditEnabled->isChecked();
}

bool KickPimContactChangeDialog::changeCategories() {
  return CatSetEnabled->isChecked();
}

void KickPimContactChangeDialog::clearContent()
{
  NoteEdit->clear();
  NoteEdit->setFocus();
}
