/***************************************************************************
                          kickpimemaildialog.cpp  -  description
                             -------------------
    begin                : Son Feb 2 2003
    copyright            : (C) 2003 by Bert Speckels
    email                : bert.speckels@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qlabel.h>
#include <qpushbutton.h>

#include <klistview.h>

#include "../kickpim.h"

#include "kickpimemaildialog.h" 



KickPimEmailDialog::KickPimEmailDialog(QWidget *parent, const char *name ) : KickPimEmailDlg(parent,name)
{
  TextLabel->setText("");

  connect (OkButton, SIGNAL(clicked()), this,SLOT(accept()));

  EmailListView->setAllColumnsShowFocus(true);  
}

KickPimEmailDialog::~KickPimEmailDialog()
{
}

void KickPimEmailDialog::setText(QString text)
{
  TextLabel->setText(text);
}

void KickPimEmailDialog::addContact(KPContact* contact)
{
  KickPimEmailDlgItem* item = new KickPimEmailDlgItem(EmailListView,KickPIM::rep()->displayName(contact),"");
  item->setRenameEnabled(0,false);  
  item->setRenameEnabled(1,true);
  item->setContact(contact);
}


void KickPimEmailDialog::accept()
{
  KickPimEmailDlgItem* item = (KickPimEmailDlgItem*)EmailListView->firstChild();
  while (item)
  {
    if (item->contact() && item->text(1))
    {
      item->contact()->addEmailAddress(item->text(1),true);      
    }
    item = (KickPimEmailDlgItem*)item->nextSibling();
  }  
  KickPimEmailDlg::accept();
}

int KickPimEmailDialog::count()
{
  return EmailListView->childCount();
}
