
/***************************************************************************
                          kickpimpreferencesdialog.cpp  -  description
                             -------------------
    begin                : Sam Nov 9 2002
    copyright            : (C) 2002 by Bert Speckels
    email                : bert.speckels@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qcheckbox.h>
#include <kcombobox.h>
#include <knuminput.h>
#include <qgroupbox.h>

#include "../kickpimoptions.h"
  
#include "kickpimpreferencesdialog.h"

KickPimPreferencesDialog::KickPimPreferencesDialog(QWidget *parent, const char *name ) : KickPimPrefDlg(parent,name)
{
}

KickPimPreferencesDialog::~KickPimPreferencesDialog()
{
}

void KickPimPreferencesDialog::setOptions(KickPimOptions* opt)
{
  // General
  ShowSidebar       ->setChecked(opt->showSidebar);
  ShowInfo          ->setChecked(opt->showInfo);
  ShowContacts      ->setChecked(opt->showContacts);
  ShowSearchField   ->setChecked(opt->showContactSearch);
  ShowCategorySelect->setChecked(opt->showContactCategories);
  ShowBirthdays     ->setChecked(opt->showBirthdays);
  ShowAnniversaries ->setChecked(opt->showAnniversaries);
  ShowCalendar      ->setChecked(opt->showCalendar);
  ShowEvents        ->setChecked(opt->showEvents);
  ShowEmails        ->setChecked(opt->showEmails);
  EnableTooltips    ->setChecked(opt->enableTooltips);
  MultipleSelection ->setChecked(opt->multipleSelection);
  AddrDisplay->setCurrentItem(opt->displayMode);
  AddrAction ->setCurrentItem(opt->defaultAction);

  // reminders
  RemindAnni           -> setChecked( opt->remindAnniversaries );
  RemindAnniFuture     -> setValue  ( opt->remindAnniFuture );
  RemindAnniPast       -> setValue  ( opt->remindAnniPast   );
  ListAnniLimit        -> setChecked( opt->listAnniLimit    );  
  ListAnniFuture       -> setValue  ( opt->listAnniFuture   );

}

void KickPimPreferencesDialog::getOptions(KickPimOptions* opt)
{
  // General
  opt->showSidebar       = ShowSidebar       -> isChecked();
  opt->showInfo          = ShowInfo          -> isChecked();
  opt->showContacts      = ShowContacts      -> isChecked();
  opt->showContactSearch = ShowSearchField   -> isChecked();
  opt->showContactCategories = ShowCategorySelect -> isChecked();
  opt->showBirthdays     = ShowBirthdays     -> isChecked();
  opt->showAnniversaries = ShowAnniversaries -> isChecked();
  opt->showEvents        = ShowEvents        -> isChecked();
  opt->showEmails        = ShowEmails        -> isChecked();
  opt->showCalendar      = ShowCalendar      -> isChecked();
  opt->enableTooltips    = EnableTooltips    -> isChecked();
  opt->multipleSelection = MultipleSelection -> isChecked();
  opt->displayMode       = AddrDisplay       -> currentItem();
  opt->defaultAction     = AddrAction        -> currentItem();  


  // reminders
  opt->remindAnniversaries = RemindAnni       -> isChecked( );
  opt->remindAnniFuture    = RemindAnniFuture -> value( );
  opt->remindAnniPast      = RemindAnniPast   -> value( );
  opt->listAnniLimit       = ListAnniLimit    -> isChecked( );
  opt->listAnniFuture      = ListAnniFuture   -> value( );

}


