/***************************************************************************
                          kmulticontentwidget.h  -  description
                             -------------------
    begin                : Mon Okt 28 2002
    copyright            : (C) 2002 by Bert Speckels
    email                : bert.speckels@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KMULTICONTENTWIDGET_H
#define KMULTICONTENTWIDGET_H

#include <qwidget.h>
#include <qlabel.h>
#include <map>

using namespace std;

/**
  *@author Bert Speckels
  */

class KMultiContentWidget : public QLabel  {
   Q_OBJECT
public: 
  KMultiContentWidget(QWidget *parent=0, const char *name=0);
  ~KMultiContentWidget();

  void setLabelWidget  ( QLabel* widget );
  void clearContent    ( );
  void addContent      ( QString name, QString content, bool set=false);
  void selectContent   ( QString name );
  QString& getContent  ( QString name );

  void setCursorShapeOnMouseOver(int shape);

protected:
  
  virtual void mousePressEvent ( QMouseEvent* event );

signals:

  void contentChanged     ( const QString& name );
  void mouseButtonClicked ( );

protected:

  QString              m_current;
  QString              m_oldLabelTitle;
  map<QString,QString> m_content;
  QLabel*              m_labelWidget;
};

#endif
