/***************************************************************************
                          KickPimContactView.h  -  description
                             -------------------
    begin                : Die Jan 21 2003
    copyright            : (C) 2003 by Bert Speckels
    email                : bert.speckels@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KICKPIMCONTACTVIEW_H
#define KICKPIMCONTACTVIEW_H

#include <qwidget.h>
#include <klistview.h>
#include "kpdynamictip.h"

#include <kabc/distributionlist.h>

using namespace KABC;

class KPContact;

class KickPimContactViewItem;
class QDragMoveEvent;
class QDragEnterEvent;
class QDragLeaveEvent;
class QDropEvent;

/** 
  *
  *@author Bert Speckels
  */
class KickPimContactView : public KListView
{

   Q_OBJECT

public:

  static const QString CAT_ALL;
  static const QString CAT_REST;
  static const QString CAT_DISTLISTS;

  KickPimContactView(QWidget *parent=0, const char *name=0);
  virtual ~KickPimContactView();

  void addContact          ( KPContact*        contact  );
  void addDistributionList ( DistributionList* distList );

  int preferredHeight();

  void updateContactList();

public slots:

  void onContactsDoubleClick  ( QListViewItem* qitem );

signals:

  void contactDoubleClicked(KickPimContactViewItem* item);

protected:

  virtual void dragEnterEvent ( QDragEnterEvent* event );
  virtual void dropEvent      ( QDropEvent* event );

protected:

  KPDynamicTip* m_tips;

  QPixmap*      m_pixmapBirthday;
  QPixmap*      m_pixmapAnniversary;
  QPixmap*      m_pixmapEvent;

  QString       m_currentGroup;

};

#endif
