/***************************************************************************
                          kickpimemailview.cpp  -  description
                             -------------------
    begin                : Mit Jan 15 2003
    copyright            : (C) 2003 by Bert Speckels
    email                : bert.speckels@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qmap.h>
#include <qlabel.h>
#include <qlayout.h>

#include <klocale.h>

#include "kickpim.h"
#include "kickpimemailview.h"

#include "mailing/kickpimmailmonitor.h"
#include "mailing/kickpimmail.h"
#include "mailing/kpmailaccount.h"


KickPimEmailView::KickPimEmailView(QWidget *parent, const char *name) : QWidget(parent,name)
{
  m_gridWidget = 0;
  m_rootLayout = 0;

  QColor bgcolor = parent->paletteBackgroundColor();
    
  setPaletteBackgroundColor ( bgcolor );

  setSizePolicy(QSizePolicy::Minimum,QSizePolicy::Fixed);

  QString iconDir = KickPIM::rep()->dirOfIcons();
  m_pixmapEmailCheck = new QPixmap(iconDir+"hi12-kickpim-email-check.png");
  m_pixmapEmail      = new QPixmap(iconDir+"hi12-kickpim-email.png");

  updateEmailAccountList();
}

KickPimEmailView::~KickPimEmailView()
{
  KPMailMonitorThreadList&  list = KickPIM::rep()->mailMonitorThreads();
  QPtrListIterator<KickPimMailMonitorThread> itor( list );
  KickPimMailMonitorThread* thread = 0;
  while ( itor.current()!=0 ) {
    thread = (KickPimMailMonitorThread*)itor.current();
    thread->monitor()->setMailLabels(0,0);
    ++itor;
  }

}


void KickPimEmailView::updateEmailAccountList()
{
  if (LogService::doLogCall) LogService::call("KickPimEmailView","updateEmailAccountList");

  // build list of accounts:
  KPMailMonitorThreadList&  list = KickPIM::rep()->mailMonitorThreads();
  if (list.isEmpty()) return;

  if (m_rootLayout==0) {
    m_rootLayout = new QVBoxLayout(this);

    QLabel* label = new QLabel( i18n("Emails") ,this);
    label->setFont(KickPIM::opt()->fontBold);
    label->setSizePolicy(QSizePolicy::Fixed,QSizePolicy::Fixed);
    m_rootLayout->addWidget(label,0);
  }
  if (m_gridWidget!=0) {
    m_rootLayout->remove( m_gridWidget );
    delete m_gridWidget;m_gridWidget=0;
  }

  m_gridWidget = new QWidget( this );
  m_rootLayout->addWidget(m_gridWidget,0);

  QGridLayout* gridLayout = new QGridLayout(m_gridWidget,0,5);
  gridLayout->addColSpacing(0,16); // icon
  gridLayout->setColStretch(1,1);  // account name
  gridLayout->setColStretch(2,0);  // num new
  gridLayout->setColStretch(3,0);  // num sep
  gridLayout->setColStretch(4,0);  // button

  QPtrListIterator<KickPimMailMonitorThread> itor( list );
  KickPimMailMonitorThread* thread = 0;
  while ( itor.current()!=0 ) {
    thread = (KickPimMailMonitorThread*)itor.current();
    addAccount( thread->monitor(), m_gridWidget, gridLayout );
    ++itor;
  }
}


bool KickPimEmailView::addAccount(KickPimMailMonitor* monitor, QWidget* parent, QGridLayout* grid)
{
  bool active    = monitor->account()->isActive();
  if (!active) return false;

  bool autoCheck = (monitor->account()->pollInterval()>0);
  // autoCheck = autoCheck && KickPIM::opt()->mailCheckEnabled;

  QString name = monitor->account()->name();
  if (LogService::doLogInfo) LogService::logInfo( LogService::CAT_MAIL, "KickPimEmailView.addAccount monitor='"+name+"'");
  int row = grid->numRows()+1;
  grid->expand(row,5);
  QLabel* label = 0;
  QLabel* newMailsLabel = 0;
  QLabel* allMailsLabel = 0;
  grid->setRowStretch(row-1,0);
  // pixmap
  label = new QLabel( parent );
  if(active) {
    if (autoCheck) label->setPixmap(*m_pixmapEmailCheck);
    else           label->setPixmap(*m_pixmapEmail);
  }
  grid->addWidget(label,row-1,0,Qt::AlignLeft | Qt::AlignVCenter);

  label = new QLabel( name, parent );
  grid->addWidget(label,row-1,1,Qt::AlignLeft | Qt::AlignVCenter);
  allMailsLabel = new QLabel( "" , parent );
  grid->addWidget(allMailsLabel,row-1,2,Qt::AlignRight | Qt::AlignVCenter);
  newMailsLabel = new QLabel( "" , parent );
  grid->addWidget(newMailsLabel,row-1,3,Qt::AlignRight | Qt::AlignVCenter);
  label = new QLabel( "" , parent );
  grid->addWidget(label,row-1,4,Qt::AlignRight | Qt::AlignVCenter);
  monitor->setMailLabels(newMailsLabel,allMailsLabel);
  return true;
}

int KickPimEmailView::preferredHeight()
{
  show();
  return height();
}
