/***************************************************************************
                          kickpimeventview.cpp  -  description
                             -------------------
    begin                : Die Jan 14 2003
    copyright            : (C) 2003 by Bert Speckels
    email                : bert.speckels@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qvbox.h>
#include <qlabel.h>
#include <qlayout.h>

#include <klocale.h>
 
#include "kickpimeventview.h"

#include "kpcontactevent.h"


KickPimEventView::KickPimEventView(QWidget *parent, const char *name ) : QScrollView(parent,name)
{  
  m_box = 0;

  QString iconDir = KickPIM::rep()->dirOfIcons();  
  m_pixmapBirthday    = new QPixmap(iconDir+"hi12-kickpim-birthday.png");
  m_pixmapAnniversary = new QPixmap(iconDir+"hi12-kickpim-anniversary.png");
  m_pixmapEvent       = new QPixmap(iconDir+"hi12-kickpim-event.png");

  QColor bgcolor = parent->paletteBackgroundColor();

  setFrameStyle             ( QFrame::NoFrame );    
  setHScrollBarMode         ( QScrollView::AlwaysOff );
  setPaletteBackgroundColor ( bgcolor );
  viewport()->setPaletteBackgroundColor(bgcolor);
}



KickPimEventView::~KickPimEventView()
{

}


void KickPimEventView::updateEventList()
{
  FUNC_CALL( KickPimEventView::updateEventListEventsChanged )

  delete m_box;m_box=0;

  KPEventList&  list  = KickPIM::rep()->events();
  KPEvent* event = list.first();
  if (!event) return;
  
  m_box = new QWidget(viewport());
  addChild(m_box);

  QVBoxLayout* vlayout = new QVBoxLayout(m_box);

  QGridLayout* grid = new QGridLayout(vlayout,0,3);
  grid->addColSpacing(0,16);
  grid->setColStretch(1,1);
  grid->setColStretch(2,2);
  
  bool nearEventsExist = false;

  //
  // List of NEAR events!
  //
  
  KPEvent* lastEvent=0;
  int   dayDist  = event ? KickPIM::rep()->distanceToDate(event->date(),event->ignoreYear()) : 0;
  while (event)
  {
    // day-label
    if (KickPIM::rep()->compareEventDate(event,lastEvent)!=0)
    {
      lastEvent = event;
      dayDist  = KickPIM::rep()->distanceToDate(event->date(),event->ignoreYear());

      // break here if the distance is to high
      if (dayDist>5) break;


      int row = grid->numRows()+1;
      grid->expand(row,3);

      QString text="";
      if      (dayDist==0) text=i18n("Today");
      else if (dayDist==1) text=i18n("Tomorrow");
      else                 text=i18n("In %1 days").arg(dayDist);

      QLabel* label = new QLabel( text ,m_box);
      grid->addMultiCellWidget(label,row,row,0,2);
      label->setFont(KickPIM::opt()->fontBold);
      
      nearEventsExist = true;
    }

    // now add the event to the grid ...
    addEvent(event,m_box,grid,false,dayDist);
    // stress test
    #ifdef STRESS_TEST
    for (int i=0;i<20;i++) addEvent(event,m_box,grid);
    #endif
    event = list.next();
  }

  //
  // List of some FAR events (Birthdays and Anniversaries)
  //

  int count=0;
  while (event)
  {
    int dayDist  = KickPIM::rep()->distanceToDate(event->date(),event->ignoreYear());

    if (          KickPIM::opt()->listAnniLimit &&
        dayDist > KickPIM::opt()->listAnniFuture    ) break;

    if (dynamic_cast<KPContactEvent*>(event)) // birthday or anniversary
    {
      if (count==0) // found some
      {
        int row = grid->numRows()+1;
        grid->expand(row,3);

        QString text = "";
        if (nearEventsExist) text = i18n("Later ...");
        else                 text = i18n("Events");

        QLabel* label = new QLabel( text ,m_box);
        grid->addMultiCellWidget(label,row,row,0,2);
        label->setFont(KickPIM::opt()->fontBold);
      }
      count++;
      addEvent(event,m_box,grid,true);
      // stress test
      #ifdef STRESS_TEST
      for (int i=0;i<20;i++) addEvent(event,m_box,grid,true);
      #endif
    
      event = list.next();
    }
  }  
}

void KickPimEventView::addEvent(KPEvent* event, QWidget* parent, QGridLayout* grid, bool displayDate, int dayDist)
{
  QPixmap* pixmap = 0;
  bool accepted = false;
  if (dynamic_cast<KPContactEvent*>(event)) // birthday or anniversary
  {
    switch(event->type())
    {
      case KPContactEvent::BIRTHDAY:
            pixmap = m_pixmapBirthday;
            accepted = KickPIM::opt()->showBirthdays;
            break;
      case KPContactEvent::ANNIVERSARY:
            pixmap = m_pixmapAnniversary;
            accepted = KickPIM::opt()->showAnniversaries;
            break;
      default:
            pixmap = m_pixmapEvent;
            accepted = false;
            break;
    }
  }
  if (!accepted) return;

  int row = grid->numRows()+1;
  grid->expand(row,3);
  QLabel* label = 0;

  // pixmap
  if (pixmap)
  {
    label = new QLabel(parent);
    label->setPixmap(*pixmap);
    grid->addWidget(label,row-1,0,Qt::AlignLeft);    
  }

  // date and/or time of event
  QFont dateFont = KickPIM::opt()->fontSmall;
  QString dateTime  = "";
  int     dateAlign = Qt::AlignRight;
  if (displayDate)
  {
    if (event->date().isValid())
    {
      dateTime+=event->date().toString("dd.MM.");
    }
    if (event->time().isValid())
    {
      if (!dateTime.isEmpty()) dateTime+=" ";
      dateTime+=event->time().toString("hh:mm");
    }
  }
  else
  {    
    if (event->date().isValid())
    {
      dateAlign = Qt::AlignLeft;

      // Patch by Harald Kmmerle (thnx!)
      // int yearDist = QDate::currentDate().year() - event->date().year();
      QDate tmpDate = QDate::currentDate().addDays(dayDist);
      int yearDist = tmpDate.year() - event->date().year();

      if (yearDist>0) dateTime = QString::number( yearDist )+" "+KickPIM::rep()->yearSign();
      dateFont.setItalic(true);
    }                                                          
  }
  
  if (!dateTime.isEmpty())
  {
    label = new QLabel(parent);
    label->setText(dateTime);
    label->setFont(dateFont);
    grid->addWidget(label,row-1,1,dateAlign);
  }

  // text of event
  if (!event->text().isEmpty())
  {
    label = new QLabel( event->text() , parent );
    label->setFont(KickPIM::opt()->fontSmall);
    grid->addWidget(label,row-1,2,Qt::AlignLeft);
  }
}

int KickPimEventView::preferredHeight()
{
  if (!m_box) return 0;
  if (layout()) layout()->activate();
  m_box->updateGeometry();
  m_box->update();
  return m_box->sizeHint().height();
}

