/***************************************************************************
                          kickpimmenu.h  -  description
                             -------------------
    begin                : Die Okt 22 2002
    copyright            : (C) 2002 by Bert Speckels
    email                : bert@speckels.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KICKPIMMENU_H
#define KICKPIMMENU_H

#include <qframe.h>
#include <kdatetbl.h> 
#include <qpoint.h>
#include <qstring.h>
#include <map>

#include <qlistview.h>

class QWidget;
class QLabel;
class QTable;

class KPDynamicTip;
class KTextBrowser;
class KListView;
class KComboBox;

class KickPimSideBar;
class KickPimContactView;
class KickPimContactViewItem;
class KickPimEventView;
class KickPimEmailView;

class KPContact;

class KickPimCard;
class KickPimOptions;
class KickPimDatePicker;
class KPopupMenu;

class QDragMoveEvent;
class QDragEnterEvent;
class QDragLeaveEvent;
class QDropEvent;


/** KickPimMenu displays the main KickPIM menu which contains a
  * collection of views.
  *
  *
  * These are the views which are displayble in the this menu:
  * - The contact view (KickPimContactView)
  * - The email view (KickPimEmailView)
  * - The event view (KickPimEVentView)
  * - The calendar view (KickPimDatePicker)
  *
  * Actions like single, double or right clicking
  * in the views are handed over to the views.
  *
  * @short The main KickPIM menu with contacts and more.
  *
  * @author Bert Speckels
  */
class KickPimMenu : public KPopupFrame
{
  Q_OBJECT
public:
  KickPimMenu(QWidget *parent=0, const char *name=0);
  ~KickPimMenu();

  void showAddrSheet( KPContact* contact );

  void showEvents   ( bool force = false );
  
  void forceHide    ( );
  
  bool isActive     ( ) { return m_isActive; }

  void preOptionSave( );

  int preferredHeight();

protected:

  void    updateLayout();
  void    initLayout();
  void    initMenues();
  QTable* initListTable();

  virtual void closeEvent ( QCloseEvent* event );
  virtual void showEvent  ( QShowEvent* );
  virtual void hideEvent  ( QHideEvent* );
  virtual void paintEvent ( QPaintEvent*);

  // void   fillEvents        ( );
  void fillContactList( );

  void doShowContactCard(KPContact* contact);

  void doNewEmail       ();
  void doRemoveContacts ();

  void doRequestEmailAddress(KPContact* contact);
  void doEditContact    (KPContact* contact);
  void doMultiEdit();

  bool JumpToContact    (const QString& name, bool searchNext = false);

public slots:

  void onCategoryChanged       ( int index );
  void onContactsChanged        ();
  void onEventsChanged          ();
  void onEmailAccountsChanged   ();
  void onContactsDoubleClicked  ( KickPimContactViewItem* item );
  void onContactsContextMenu    ( KListView* view, QListViewItem* qitem, const QPoint& pos );
  void onContactsPopupSelection ( int id );

  void onShortlyAfterStart();

  void onSearchTextChanged(const QString&);
  void onSearchNext();

  void onDateChanged         ();

protected:

  void hideMe();
  virtual void rebuildContactCategories();
  virtual void keyPressEvent(QKeyEvent* e);

protected:

  KickPimSideBar*     m_sideBar;
  QWidget*            m_titleWidget;
  KickPimContactView* m_contactView;
  KickPimEmailView*   m_emailView;
  KickPimEventView*   m_eventView;
  KickPimDatePicker*  m_datePicker;
  KComboBox*          m_catSelect;
  QLabel*             m_dateLabel;
  QDate               m_lastDate;

  KPopupMenu*         m_addrPopup;
  KPopupMenu*         m_distPopup;

  KickPimCard*        m_card;

  QString             m_lastSearch;

  bool                m_isActive;
  QTimer*             m_afterStartTimer;
};

#endif
