/***************************************************************************
                          kickpimsidebar.cpp  -  description
                             -------------------
    begin                : Mit Feb 5 2003
    copyright            : (C) 2003 by Bert Speckels
    email                : bert.speckels@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qpainter.h>
#include <kpixmap.h>
#include <kpixmapeffect.h>
#include <kglobalsettings.h>
 
#include "kickpimsidebar.h"
#include "kickpim.h"

KickPimSideBar::KickPimSideBar(QWidget *parent, const char *name ) : QWidget(parent,name)
{
  LogService::construct("KickPimSideBar");
  if (KickPIM::opt()) {
    QFontMetrics fm( KickPIM::opt()->fontBig );
    setFixedWidth( fm.ascent()+2 );
  }
  m_gradientColor1 = QColor(196,0,0);
  m_gradientColor2 = QColor(0,0,196);
}

KickPimSideBar::~KickPimSideBar()
{
  LogService::destruct("KickPimSideBar");
}

void KickPimSideBar::setGradientColors(QColor col1, QColor col2)
{
  LogService::call("KickPimSideBar","setGradientColors");
  m_gradientColor1 = col1;
  m_gradientColor2 = col2;
}

void KickPimSideBar::paintEvent( QPaintEvent* /*ev*/ )
{
  LogService::call("KickPimSideBar","paintEvent");

  QPainter paint( this );
  paint.setBackgroundMode(Qt::TransparentMode);

  //LogService::logInfo(LogService::CAT_KICKPIM,"KickPimSideBar::paintEvent  rect-init");
  QRect rc = rect();
  QRect rec(rc.left()-rc.height(),rc.top(),rc.height(),rc.width());
  QRect titleRec = rec;
  titleRec.setLeft(titleRec.left()+10);
  //LogService::logInfo(LogService::CAT_KICKPIM,"  -> rect: "+QString::number(titleRec.left())+","+QString::number(titleRec.top())+" / "+QString::number(titleRec.right())+","+QString::number(titleRec.bottom()));

  //LogService::logInfo(LogService::CAT_KICKPIM,"KickPimSideBar::paintEvent  paint-init");
  paint.setPen( Qt::blue );
  paint.rotate(-90);
  paint.setPen ( paletteForegroundColor() );
  if (KickPIM::opt()) paint.setFont( KickPIM::opt()->fontBig );

  // gradient
  //LogService::logInfo(LogService::CAT_KICKPIM,"KickPimSideBar::paintEvent  gradient");
  QRect gradRec( int(rec.left()+rec.width()*0.60),rec.top(),int( rec.width()-rec.width()*0.60+1 ),rec.height());
  //LogService::logInfo(LogService::CAT_KICKPIM,"  -> rect: "+QString::number(gradRec.left())+","+QString::number(gradRec.top())+" / "+QString::number(gradRec.right())+","+QString::number(gradRec.bottom()));
  KPixmap gradient;
  gradient.resize( gradRec.width(), gradRec.height() );
  KPixmapEffect::gradient(gradient,m_gradientColor1,m_gradientColor2,KPixmapEffect::HorizontalGradient);
  paint.drawPixmap(gradRec, gradient );

  // texts
  //LogService::logInfo(LogService::CAT_KICKPIM,"KickPimSideBar::paintEvent  text (title)");
  QString title = "KickPIM "+QString(VERSION);
  //LogService::logInfo(LogService::CAT_KICKPIM,"  -> rect: "+QString::number(titleRec.left())+","+QString::number(titleRec.top())+" / "+QString::number(titleRec.right())+","+QString::number(titleRec.bottom()));
  //LogService::logInfo(LogService::CAT_KICKPIM,"  -> title: '"+title+"'");
  paint.drawText( titleRec, AlignLeft | AlignTop, title);
  if (KickPIM::opt()) paint.setFont( KickPIM::opt()->fontSmall );
  //LogService::logInfo(LogService::CAT_KICKPIM,"KickPimSideBar::paintEvent  text (version title)");
  QString versionTitle = VERSION_TITLE + QString("   ");
  //LogService::logInfo(LogService::CAT_KICKPIM,"  -> rect: "+QString::number(titleRec.left())+","+QString::number(titleRec.top())+" / "+QString::number(titleRec.right())+","+QString::number(titleRec.bottom()));
  //LogService::logInfo(LogService::CAT_KICKPIM,"  -> version title: '"+versionTitle+"'");
  paint.drawText( titleRec, AlignRight | AlignVCenter, versionTitle);
  //LogService::logInfo(LogService::CAT_KICKPIM,"KickPimSideBar::paintEvent  finished.");
}

