/***************************************************************************
                          KPContactEvent.cpp  -  description
                             -------------------
    begin                : Don Okt 24 2002
    copyright            : (C) 2002 by Bert Speckels
    email                : bert@speckels.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kpcontactevent.h"
#include "kickpim.h"

KPContactEvent::KPContactEvent()
{
  m_type    = BIRTHDAY;
  m_text    = "";
  m_date    = QDate(25,61,61); // invalid
  m_contact = 0;
};

KPContactEvent::~KPContactEvent()
{
}

bool KPContactEvent::isEmpty() const
{
  return m_date.isValid(); // every event needs a date
}

void KPContactEvent::setText(QString text)
{
  m_text = text;
}

void KPContactEvent::setDate(QDate date)
{
  m_date = date;
}

void KPContactEvent::setTime(QTime)
{
  // birthdays and anniversaries don't need a time-value
}

void KPContactEvent::setContact(KPContact* contact)
{
  m_contact = contact;
}

void KPContactEvent::setType(int type)
{
  m_type = type;
}


QString KPContactEvent::text() const
{
  return m_text;
}

QDate KPContactEvent::date() const
{
  return m_date;
}

QTime KPContactEvent::time() const
{
  return QTime(25,61,61); // return invalid time
}


int KPContactEvent::type() const
{
  return m_type;
}

KPContact* KPContactEvent::contact() const
{
  return m_contact;
}




