/***************************************************************************
                          kpevent.h  -  description
                             -------------------
    begin                : Fre Jan 17 2003
    copyright            : (C) 2003 by Bert Speckels
    email                : bert.speckels@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KPEVENT_H
#define KPEVENT_H

#include <qdatetime.h>
#include <qstring.h>
#include <qptrlist.h>

#include "kpcontact.h"

/**
  *@author Bert Speckels
  */

class KPEvent : public QObject
{

  Q_OBJECT
  
public: 
  KPEvent();
  virtual ~KPEvent();

  virtual bool isEmpty() const = 0;
  
  virtual void setText(QString text) = 0;
  virtual void setDate(QDate date) = 0;
  virtual void setTime(QTime time) = 0;
  virtual void setContact(KPContact* contact) = 0;
  virtual void setType(int type) = 0;

  virtual bool ignoreYear() { return false; };
  
  virtual QString    text()       const = 0;
  virtual QDate      date()       const = 0;
  virtual QTime      time()       const = 0;
  virtual KPContact* contact()    const = 0;
  virtual int        type()       const = 0;
};


class KPEventList : public QPtrList<KPEvent>
{
  public:
    KPEventList();
    ~KPEventList();

    virtual int compareItems(QPtrCollection::Item item1,QPtrCollection::Item item2);
};

#endif
