/***************************************************************************
                          kpmailimapdialog.cpp  -  description
                             -------------------
    begin                : Mit Mr 5 2003
    copyright            : (C) 2003 by Bert Speckels
    email                : bert.speckels@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kpmailimapdialog.h"
#include <qspinbox.h>

#include <qcheckbox.h>
#include <qlabel.h>
#include <klineedit.h>
#include <kpassdlg.h>
#include <kmessagebox.h>
#include <klocale.h>
#include <kcombobox.h>
#include "../LogService.h"
#include <klistbox.h>

#include "kpmailaccount.h"

KPMailImapDialog::KPMailImapDialog(QWidget *parent, const char *name ) : KPMailImapDlg(parent,name)
{
  connect((QObject*)OkButton,SIGNAL(pressed()),this,SLOT(accept()));
  connect((QObject*)CancelButton,SIGNAL(pressed()),this,SLOT(reject()));
}

KPMailImapDialog::~KPMailImapDialog()
{

}


void KPMailImapDialog::setAccountData(KPMailAccount* account)
{
  m_account = account;
  if (m_account) {
    AccountName->setText(m_account->name());
    Server   ->setText( m_account->url().host() );
    User     ->setText( m_account->url().user() );
    Password ->setText( m_account->url().pass() );
    if (m_account->isActive()) AccountState->setCurrentItem(0);
    else                       AccountState->setCurrentItem(1);
    QString path = m_account->url().path();
    Mailbox  ->setText( path.right( path.length()-1 ) );
    int pollIval = m_account->pollInterval();
    AutoCheck->setChecked( pollIval>=0 );
    onAutoCheckToggled( pollIval>=0 );
    if (pollIval<0) pollIval = 5 * 60; // 5 minutes by default
    CheckMinutes->setValue( pollIval/60 );
    CheckSeconds->setValue( (int)(pollIval%60) );
  }
}

void KPMailImapDialog::updateAccount( KPMailAccount* account )
{
  KPMailURL url;
  url.setProtocol( "imap4" );
  url.setUser( User->text() );
  url.setHost( Server->text() );
  url.setPass( Password->text() );
  QString mailboxName = Mailbox->text().stripWhiteSpace();
  if ( mailboxName.length()>0 ) {
    if ( !mailboxName.startsWith("/") ) mailboxName="/" + mailboxName;
    url.setPath( "/" + Mailbox->text() );
  }
  else url.setPath("");  
  int state = AccountState->currentItem();
  account->setActive( (state==0) );
  account->setName( AccountName->text( ) );
  account->setUrl(url);
  int pollIval = -1;
  if (AutoCheck->isChecked()) pollIval = CheckMinutes->value() * 60 + CheckSeconds->value();
  account->setPollInterval( pollIval );
  LogService::logInfo( LogService::CAT_MAIL, "KPMailImapDialog: New or updated account: "
                                             +url.prettyURL());
}

void KPMailImapDialog::accept()
{
  // check the account name
  QString name = AccountName->text();
  name = name.stripWhiteSpace();
  if (name.length()==0) {
    KMessageBox::information(0, i18n("Please enter a name for this account!"),
                                i18n("Enter a name!") );
    return;
  }

  QDialog::accept();
}

