/***************************************************************************
 *   Copyright (C) 2006 by Valentine Sinitsyn                              *
 *   e_val@inbox.ru                                                        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef CPUFREQD_H
#define CPUFREQD_H

#include "cpufreqdconnection.h"
#include "cpufreqdprofile.h"
#include <qaction.h>
#include <qobject.h>
#include <qpopupmenu.h>
#include <qstring.h>
#include <qsignalmapper.h>
#include <qvaluevector.h>
#include <qptrlist.h>
#include <stdint.h>

class CPUFreqd: public QObject {
	Q_OBJECT

	public:
		CPUFreqd();
		virtual ~CPUFreqd();

		bool enabled() const;
		QValueVector<CPUFreqdProfile> & getProfiles(bool reconnect = false);
		QPopupMenu* menu();

	public slots:
		void setManual();
		void setDynamic();
		void setProfile(int id);

	private:
		CPUFreqdConnection m_conn;
		QValueVector<CPUFreqdProfile> m_profiles;
		QPopupMenu *m_menu;
		QSignalMapper *m_mapper;
		QAction* m_dynamic;
		QActionGroup* m_items;
		QPtrList<QAction>* m_actions;

		void setMode(uint32_t mode);

	private slots:
		void updateMenu();
};

#endif
