/***************************************************************************
 *   Copyright (C) 2007 by Ken Werner                                      *
 *   ken.werner@web.de                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef LABELSOURCE_H
#define LABELSOURCE_H

#include "triggeredsource.h"
#include "labelsourcePrefs.h"

class QLabel;

/**
 * LabelSource displays its value on a configurable QLabel
 * @author Ken Werner
 */
class LabelSource : public TriggeredSource{
	Q_OBJECT //macro which activates signals and slots (moc)
public:
	/**
	 * Creates a new DefaultSource from the given File
	 */
	LabelSource(QWidget* inParent);
	
	virtual ~LabelSource();

	/**
	 * Returns the Label of this source that is displayed in the kicker
	 */
	QWidget* getWidget();

	/**
	 * fills the prefs gui with appropriate values
	 */
	virtual void updatePrefsGUI();

    /**
     * realizes the widget. that means, create the QLabel.
     */
    virtual void realizeWidget();

protected slots:
	/**
	 * updates the label
	 */
	virtual void updateLabel(const QString& inValue);

	/**
	 * Applies the prefs
	 */
	virtual void applyPrefs();

	/**
	 * Saves the prefs (implicit apply)
	 */
	virtual void savePrefs(KConfig* inKConfig);

	/**
	 * Loads the prefs
	 */
	virtual void loadPrefs(KConfig* inKConfig);

	/**
	 * This method enables or disables various widgets of the preferences dialog depending on isEnabled and isShownOnApplet
	 * This method can be extended in sub classes
	 */
	virtual void setPrefsWidgetsEnabled(bool isEnabled, bool isShownOnApplet);

protected:
	/**
	 * Allows subclasses adding their own preferences using the addPrefs method
	 */
	virtual void createSubPrefs(QWidget* inParent);

	/**
	 * Displays the content of that source
	 */
	QLabel* mLabel;

	/**
	 * the parent of the label we are going to create
	 */
	QWidget* mParent;
	
private:
	/**
	 * the LabelSources part of the preferences gui 
	 */
	LabelSourcePrefs* mLabelSourcePrefs;
};
#endif //LABELSOURCE_H
