%define version 0.177.3

%define use_xdg_menu %{!?_with_xdg_menu:0}%{?_with_xdg_menu:1}

%define is_suse      %(if [ -e /etc/SuSE-release ]; then echo "yes"; else echo "no"; fi)
%if %{is_suse} == "yes"
%define _prefix /opt/kde3
%endif

%define is_x86_64 %(if [ "x86_64" == `uname -m` ]; then echo "yes"; else echo "no"; fi)

Summary: 2ch client for KDE
Name: kita
Version: %{version}
Release: 1
Source: kita-%{version}.tar.gz
License: GPL
URL: http://sourceforge.jp/projects/kita/
Group: Application/Internet
Packager: Hideki Ikemoto <ikemo@users.sourceforge.jp>
BuildRoot: %{_tmppath}/%{name}-%{version}-root

# TurboLinux uses 'Serial' field.
#Serial: 2004051601

%description
2ch client for KDE	

%prep
%setup -q

%build
./configure --prefix=%{_prefix} \
%if %{is_x86_64} == "yes"
 --enable-libsuffix=64 \
 %if %{is_suse} == "yes"
 --with-qt-libraries=/usr/lib64/qt-3.3/lib64 \
 %else
 --with-qt-libraries=/usr/lib64/qt-3.3/lib \
 %endif
%endif
%if %{use_xdg_menu}
  --enable-xdg-menu
%endif

make clean
make

%install
rm -rf %{buildroot}
%makeinstall

%clean
rm -rf %{buildroot}

%post -p /sbin/ldconfig
%postun -p /sbin/ldconfig
%files
%defattr(-, root, root)
%doc AUTHORS COPYING ChangeLog NEWS README README.2ch TODO
%{_bindir}/*
%{_libdir}/*.so*
%{_libdir}/*.la
#%{_libdir}/kde3/*.so
#%{_libdir}/kde3/*.la
%{_datadir}/apps/kita/*ui.rc
%{_datadir}/apps/kita/icons/*/*/*/*
#%{_datadir}/apps/konqsidebartng/*/*
%if %{use_xdg_menu}
%{_datadir}/applications/kita.desktop
%else
%{_datadir}/applnk/Internet/kita.desktop
%endif
#%{_datadir}/applnk/Settings/Network/kcm_k2ch.desktop
#%{_datadir}/config/kio_k2chrc
#%{_datadir}/services/*
#%{_datadir}/mimelnk/text/*
%{_datadir}/locale/ja/LC_MESSAGES/*
%{_datadir}/icons/*/*/*/*
%{_datadir}/doc/HTML/en/kita/*
%changelog
* Sun Nov 21 2004 Hideki Ikemoto<ikemo@users.sourceforge.jp>
- remove kitapart/kita*ui.rc

* Sat Oct 07 2004 Hideki Ikemoto<ikemo@users.sourceforge.jp>
- set %%{_prefix} if SuSE

* Sat May 15 2004 Hideki Ikemoto<ikemo@users.sourceforge.jp>
- add 'Serial' field (comment)

* Sat Dec 13 2003 Hideki Ikemoto<ikemo@users.sourceforge.jp>
- don't use %%configure

* Mon Oct 13 2003 Hideki Ikemoto<ikemo@users.sourceforge.jp>
- add files

* Wed Mar 03 2003 Hideki Ikemoto<ikemo@users.sourceforge.jp>
- initial release.
