/*
 * This file is a part of KleanSweep.
 *
 * Copyright (C) 2005 Pawel Stolowski <pawel.stolowski@wp.pl>
 *
 * KleanSweep is free software; you can redestribute it and/or modify it
 * under terms of GNU General Public License by Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY. See GPL for more details.
 */

#include "dirlistwidget.h"
#include <qhbox.h>
#include <qvbox.h>
#include <kpushbutton.h>
#include <kurlrequester.h>
#include <klistbox.h>
#include <klocale.h>
#include <qsizepolicy.h>
#include <qlabel.h>
#include <kdialog.h>
#include <kstandarddirs.h>
#include <kiconloader.h>

DirListWidget::DirListWidget(const QString &title, QWidget *parent): QHGroupBox(title, parent)
{
	QVBox *box0 = new QVBox(this);
	box0->setSpacing(KDialog::spacingHint());
	path = new KURLRequester(box0);
	path->setMode(KFile::Directory | KFile::ExistingOnly | KFile::LocalOnly);
	path->setDisabled(true);
	connect(path, SIGNAL(textChanged(const QString &)), this, SLOT(updateSelectedItem(const QString &)));
	list = new KListBox(box0);
	connect(list, SIGNAL(selected(QListBoxItem *)), this, SLOT(pathSelected(QListBoxItem *)));
	connect(list, SIGNAL(highlighted(QListBoxItem *)), this, SLOT(pathSelected(QListBoxItem *)));

	QVBox *box1 = new QVBox(this);
	box1->setSpacing(KDialog::spacingHint());
	b_new = new KPushButton(KGlobal::iconLoader()->loadIconSet("add", KIcon::Small), i18n("New"), box1);
	b_rem = new KPushButton(KGlobal::iconLoader()->loadIconSet("remove", KIcon::Small), i18n("Remove"), box1);
	//b_rem->setDisabled(true);
	new QLabel(box1);
	b_new->setSizePolicy(QSizePolicy(QSizePolicy::Maximum, QSizePolicy::Fixed));
	b_rem->setSizePolicy(QSizePolicy(QSizePolicy::Maximum, QSizePolicy::Fixed));
	connect(b_new, SIGNAL(clicked()), this, SLOT(newClicked()));
	connect(b_rem, SIGNAL(clicked()), this, SLOT(removeClicked()));
}

DirListWidget::~DirListWidget()
{
}

void DirListWidget::newClicked()
{
	list->blockSignals(true);
	QListBoxText *item = new QListBoxText(list, "");
	list->setSelected(item, true);
	path->clear();
	path->setDisabled(false);
	list->blockSignals(false);
}

void DirListWidget::removeClicked()
{
	int item = list->currentItem();
	if (item >= 0)
	{
		list->blockSignals(true);
		path->clear();
		list->removeItem(item);
		list->blockSignals(false);
	}
}

void DirListWidget::updateSelectedItem(const QString &txt)
{
	int item = list->currentItem();
	if (item >= 0)
	{
		//b_rem->setDisabled(false);
		list->blockSignals(true);
		list->changeItem(txt, item);
		list->blockSignals(false);
	}
	else
	{
		//b_rem->setDisabled(true);
	}
}

void DirListWidget::pathSelected(QListBoxItem *item)
{
	if (item)
	{
		path->setDisabled(false);
		list->blockSignals(true);
		path->setURL(item->text());
		list->blockSignals(false);
	}
	else
		path->setDisabled(true);
}

void DirListWidget::insertStringList(const QStringList &strlist, int index)
{
	list->insertStringList(strlist, index);
}

QStringList DirListWidget::getAllPaths()
{
	QStringList paths;
	for (int i=0; i<list->count(); i++)
		paths << list->item(i)->text();
	return paths;
}

#include "dirlistwidget.moc"
