/*
 * This file is a part of KleanSweep.
 *
 * Copyright (C) 2005 Pawel Stolowski <pawel.stolowski@wp.pl>
 *
 * KleanSweep is free software; you can redestribute it and/or modify it
 * under terms of GNU General Public License by Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY. See GPL for more details.
 */

#ifndef __LOGWIDGET_H
#define __LOGWIDGET_H

/*! \file sweeperlogwidget.h */

#include <qtable.h>

class QPixmap;
class QTextStream;

class LogWidget: public QTable
{
	public:
		enum Status { STATUS_OK, STATUS_FAIL, STATUS_INFO };

	protected:
		int lastnum;
		QPixmap *status_ok;
		QPixmap *status_fail;
		QPixmap *status_info;

	protected slots:
		void clicked(int row);

	public slots:
		void appendOperation(const QString &txt);
		void appendOperation(const QString &txt, LogWidget::Status status);
		void setOperationStaus(LogWidget::Status status, const QString &descr = QString::null);
		
	public:
		LogWidget(QWidget *parent);
		virtual ~LogWidget();
		QString getLog();
		void writeLog(QTextStream &str);
		bool isEmpty() const;
};

#endif

