/*
 * This file is a part of KleanSweep.
 *
 * Copyright (C) 2005 Pawel Stolowski <pawel.stolowski@wp.pl>
 *
 * KleanSweep is free software; you can redestribute it and/or modify it
 * under terms of GNU General Public License by Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY. See GPL for more details.
 */

#include "sweepfileinfo.h"
#include <kurl.h>

#ifdef DEBUG
#include <iostream>
#endif

SweepFileInfo::SweepFileInfo(const KURL &path, char score): KFileItem(KFileItem::Unknown, KFileItem::Unknown, path, false), remove(false), target(QString::null), scre(score)
{
}

SweepFileInfo::~SweepFileInfo()
{
}

void SweepFileInfo::markForRemoval(bool f)
{
	#ifdef DEBUG
	std::cerr << __PRETTY_FUNCTION__ << " " << name() << " " << f << std::endl;
	#endif

	remove = f;
}

bool SweepFileInfo::isMarkedForRemoval() const
{
	return remove;
}

void SweepFileInfo::setTarget(const QString &path)
{
	target = path;
}

QString SweepFileInfo::getTarget() const
{
	return target;
}

int SweepFileInfo::getScore() const
{
	return scre;
}

