/***************************************************************************
   Copyright (C) 2007
   by Marco Gulino <marco@kmobiletools.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the
   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
 ***************************************************************************/
#include "exportphonebookdlg.h"

#include <klocale.h>
#include <qbuttongroup.h>
#include <kfiledialog.h>
#include <kabc/resource.h>
#include <kabc/resourcefile.h>
#include <kabc/stdaddressbook.h>

#define SAVE_TO_FILE 1
#define APPEND_TO_KABC 0

exportPhonebookDlg::exportPhonebookDlg(ContactPtrList *addresseeList, QWidget *parent, const char *name)
    : KDialogBase(parent, name, true, i18n("Export Phonebook"), Ok|Cancel)
{
    p_addresseeList=addresseeList;
    m_widget=new exportPhonebook(this);
    setMainWidget(m_widget);
}


exportPhonebookDlg::~exportPhonebookDlg()
{
}


#include "exportphonebookdlg.moc"


/*!
    \fn exportPhonebookDlg::slotOk()
 */
void exportPhonebookDlg::slotOk()
{
    KABC::AddressBook *addressbook;
    if ( m_widget->exportOptions->selectedId() == SAVE_TO_FILE )
    {
        QString saveFileName=KFileDialog::getSaveFileName(":vcf", " text/directory", this);
        if(saveFileName.isNull()) return;
        KABC::Resource* resource=new KABC::ResourceFile( saveFileName );
        resource->setReadOnly (false);
        addressbook=new KABC::AddressBook();
        addressbook->addResource(resource);
//         addressbook->load();
//         addressbook->clear();
        KABC::Ticket *saveTicket=addressbook->requestSaveTicket();
        for(p_addresseeList->first(); p_addresseeList->current(); p_addresseeList->next() )
            addressbook->insertAddressee( *(p_addresseeList->current() ) );
        addressbook->save( saveTicket );
//         addressbook->releaseSaveTicket( saveTicket );
        resource->close();
    }
    if ( m_widget->exportOptions->selectedId() == APPEND_TO_KABC )
    {
        addressbook=KABC::StdAddressBook::self();
        for(p_addresseeList->first(); p_addresseeList->current(); p_addresseeList->next() )
            addressbook->insertAddressee( *(p_addresseeList->current() ) );
        addressbook->save(addressbook->requestSaveTicket() );
    }
    KDialogBase::slotOk();
}
