/***************************************************************************
   Copyright (C) 2007
   by Marco Gulino <marco@kmobiletools.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the
   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
 ***************************************************************************/
#ifndef _KMOBILETOOLSDEVICEPART_H_
#define _KMOBILETOOLSDEVICEPART_H_

#include <kdebug.h>
#include <qptrlist.h>
#include <kabc/addressbook.h>
#include <kabc/resourcefile.h>
#include <qfile.h>
#include <klistview.h>

#include "config.h"
#ifdef HAVE_KCAL
#include <libkcal/calendarlocal.h>
#include "calendar.h"
#endif

#include <klistviewsearchline.h>
#include "kmobiletoolsengine.h"
#include "kmobiletools_mainpart.h"
#include "statusbar.h"
#include "deviceIFace.h"
#include "mainWidget.h"
#include "sms.h"
#include "homepage.h"

class QWidget;
// class mainWidget;
class QString;
class KListView;
class QListViewItem;
class StatusBar;
class KStatusBar;
class addressDetails;
class smsPart;
class KProgress;
class KStatusBarLabel;
class kmobiletoolsMainPart;
class StatusBarProgressBox;
class KAction;
namespace KParts
{
    class StatusBarExtension;
    class ReadOnlyPart;
}

/**
 * This is a "Part".  It that does all the real work in a KPart
 * application.
 *
 * @short Device Part
 * @author Marco Gulino <marco.gulino@gmail.com>
 * @version 0.5.0
 */
class KABCResFile : public KABC::ResourceFile
{
Q_OBJECT
    public:
        KABCResFile(const QString &fileName, const QString &formatName="vcard")
    : KABC::ResourceFile(fileName, formatName){ setType("file");}
};
class DeviceListViewItem : public KListViewItem
{
    public:
        DeviceListViewItem (QListView *parent, QString s1) : KListViewItem(parent,s1) {}
        QString deviceName() const { return devicename; }
        void setDeviceName(const QString &devname) { devicename=devname; }
    private:
        QString devicename;
};

class ContactListViewItem : public KListViewItem
{
    public:
        ContactListViewItem(QListView *parent, KABC::Addressee *contact, bool readOnly=false);
        KABC::Addressee *contact() { return p_contact; }
        bool readOnly() { return b_ro; }
    private:
        KABC::Addressee *p_contact;
        bool b_ro;
};

class ContactsSearchLine : public KListViewSearchLine
{
    Q_OBJECT
    public:
        ContactsSearchLine (QWidget *parent=0, KListView *listView=0, const char *name=0)
    : KListViewSearchLine(parent, listView, name) {}
    protected:
        virtual bool itemMatches (const QListViewItem *item, const QString &s) const;
};

class ContactsSearchLineWidget : public KListViewSearchLineWidget
{
    Q_OBJECT
    public:
        ContactsSearchLineWidget(KListView *listView=0, QWidget *parent=0, const char *name=0)
    : KListViewSearchLineWidget(listView, parent, name), p_searchline(NULL) {};
        KListViewSearchLine *   searchLine () const { return p_searchline; }
        virtual KListViewSearchLine * createSearchLine (KListView *listView);
    private:
        ContactsSearchLine *p_searchline;
};

class kmobiletoolsDevicePart : public QObject, virtual public DeviceIFace
{
    Q_OBJECT
public:
    kmobiletoolsDevicePart(QWidget *parentWidget, const char *widgetName,kmobiletoolsMainPart *parent, const char *name);
    virtual ~kmobiletoolsDevicePart();
    virtual KListViewItem *listViewItem() { return p_listViewItem; }
    bool isConnected() { return devIsConnected; }
    void stopDevice();
    void resumeDevice();
    QString deviceVendor() { return engine->rawManufacturer(); }
    QString deviceModel() { return engine->model(); }
    const QString friendlyName();
    static const QStringList parseAddressee(KABC::Addressee *addressee);
    void raiseDevice();
    bool openFile() { return false; }
    QWidget *widget() { return /*(QWidget*)*/ m_widget;}
    const QPtrList<KAction> actionList() { return l_actionList;}
    SMSList *smsList() { return engine->smsList(); }
    void setupWidgets();
    kmobiletoolsMainPart *parent() { return (kmobiletoolsMainPart *) QObject::parent(); }
#ifdef HAVE_KCAL
    KCal::CalendarLocal * calendar() { return p_calendar; }
#endif
private:
    mainWidget *m_widget;
    ContactsSearchLineWidget *slwidget;
    StatusBar *m_statusbar;
    kmobiletoolsEngine* engine;
    KListViewItem *p_smsItem;
    DeviceListViewItem *p_listViewItem;
    homepagePart *home;
    QTimer *statusPollTimer;
    QTimer *smsPollTimer;
    addressDetails *p_addressDetails;
    smsPart *p_smsPart;
    bool devIsConnected;
    int suspends_count;
//     QFile f_pidfile;
    KParts::StatusBarExtension *statusBarExtension;
    QPtrList<KAction> l_actionList;
    int memslotSelected, smsTypeSelected;
    int smsnotifynum;
    KParts::ReadOnlyPart *korgpart;
    kmobiletoolsMainPart *p_mainPart;
#ifdef HAVE_KCAL
    KCal::CalendarLocal *p_calendar;
#endif
    /// StatusBar items
    StatusBarProgressBox *statusBarBox;
    KProgress *signalProgress;
    KProgress *batteryProgress;
    KStatusBarLabel *networkLabel;
    KStatusBarLabel *devNameLabel;
    KStatusBarLabel *voidLabel;
    KStatusBarLabel *batteryLabel;
    KStatusBarLabel *signalLabel;
    bool b_dialing, b_dialing_called;

    protected:
//         void partActivateEvent( KParts::PartActivateEvent *event );
//         void guiActivateEvent  ( KParts::GUIActivateEvent *event);
public slots:
    void errNotConnected();
    void addSMSFolders();
    void updatePB();
    void updatePB(int slot, const ContactPtrList&);
    void updateAllContacts();
    void updateAllContacts(ContactPtrList *addressBook);
    void updateSMSList();
    void clicked ( QListViewItem * item );
    void printInfoPage(int i) { home->printInfoPage(i, engine); }
    void pb_clicked ( QListViewItem * item );
    void devDisconnected();
    void devConnected();
    void disableWidgets();
    void enableWidgets(bool fetch=true);
    void smsSelected(QListViewItem *smsItem);
    void setupStatusBar();
    void clearStatusBar();
    void sendSMS(const QString&, const QString& );
    void storeSMS(const QString&, const QString& );
    void loadEngine();
    void jobDone(kmobiletoolsJob::JobType);

    /*!
        \fn kmobiletoolsDevicePart::encodings()
     */
    QStringList encodings()
    {
        return engine->encodings();
    }
    void slotAddContact();
    void slotEditContact(KABC::Addressee *);
    void slotDeleteContact();
    void slotFetchPhonebook();
    void slotSavePhonebook();
    void slotUploadAddressBook();
    void addresseeListRightClick(QListViewItem *item, const QPoint &point, int column);
    void smsListRightClick(QListViewItem *item, const QPoint &point, int column);
    void smsModified(const QCString& smsUID);
    void smsAdded(const QCString& smsUID);
    void smsRemoved(const QCString& smsUID);
    void smsFolderClicked( QListViewItem * item );
    void slotNewSMS() { slotNewSMS(QString::null); }
    void slotNewSMS(const QString &);
    void openURL(const KURL &url);
    void updateSMSCount();
    void fullPhonebook();
    void slotFetchCalendar();
    void slotCalendarFetched();
    void slotExportSMSList();
    void slotExportSMSListToCSV();
    void slotStatusBar();
    void slotSaveAddressBook();
    void slotSendStoredSMS(SMS*);
    void slotRing(bool);
    void slotDial();
    void slotDialNumber(const QString &);
    void raisePage(int);
    QString currentDeviceName() const;
    void switch2filesystem();
    void contactsTabChanged();

signals:
        void disconnected();
        void connected();
        void error();
        void phonebookUpdated();
        void command(const QString &);
        void deleteThis(const QString &);
};

class KInstance;
class KAboutData;

#endif // _KMOBILETOOLSPART_H_
