/***************************************************************************
   Copyright (C) 2007
   by Marco Gulino <marco@kmobiletools.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the
   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
 ***************************************************************************/
#include "newsmsdlg.h"
#include <klocale.h>
#include <qlayout.h>
#include <qframe.h>
#include <ktextedit.h>
#include <kstatusbar.h>
#include <kpushbutton.h>
#include <klistview.h>
#include <klineedit.h>
#include <kguiitem.h>
#include <kmessagebox.h>
#include <kdebug.h>
#include "kmobiletoolshelper.h"
#include "pickphonenumberdialog.h"
#include "encodingshelper.h"
#include "engineslist.h"
#include "sms.h"
#include "kmobiletoolsengine.h"

newSMSDlg::newSMSDlg(QWidget *parent, const char *name)
    : KDialogBase (parent, name, true, i18n("New SMS"), Cancel | User1 | User2 )
{
    kdDebug() << "newSMSDlg with name " << name << endl;
    p_sms=0;
    m_uiNewSMS=new ui_newsms(this);
    setMainWidget( m_uiNewSMS);
//     m_uiNewSMS->smsText->setText(name);
    QVBoxLayout *layoutStatusBar=new QVBoxLayout(m_uiNewSMS->statusBarFrame);
    statusBar=new KStatusBar(m_uiNewSMS->statusBarFrame);
    layoutStatusBar->addWidget(statusBar);
    connect(m_uiNewSMS->smsText, SIGNAL(textChanged()), this, SLOT(smsTextChanged()) );
    connect(m_uiNewSMS->pickNumber, SIGNAL(clicked() ), this, SLOT(pickPhoneNumber() ));
    connect(m_uiNewSMS->editNumber, SIGNAL(textChanged(const QString &) ), this, SLOT(textNumberChanged( const QString & ) ));
    connect(m_uiNewSMS->lv_numbers, SIGNAL(clicked(QListViewItem*)), this, SLOT(NumberClicked( QListViewItem* )) );
    connect(m_uiNewSMS->buttonAdd, SIGNAL(clicked() ), this, SLOT(addClicked() ) );
    connect(m_uiNewSMS->buttonRemove, SIGNAL(clicked() ), this, SLOT(remClicked() ) );
    setButtonGuiItem(User1, KGuiItem(i18n("Send SMS directly", "Send"), "mail_send", i18n("Send SMS directly") ));
    setButtonGuiItem(User2, KGuiItem(i18n("Save SMS to mobile phone memory", "Save"), "filesave", i18n("Save SMS to mobile phone memory") ));
    resize(567,390);
}


newSMSDlg::~newSMSDlg()
{
}


#include "newsmsdlg.moc"


/*!
    \fn newSMSDlg::smsTextChanged()
 */
void newSMSDlg::smsTextChanged()
{
    QString statusTexT=i18n("SMS Text Length: %1 characters. Total SMS Count: %2. Encoding: %3").arg(m_uiNewSMS->smsText->length() )
            .arg(SMS::getMultiTextCount(m_uiNewSMS->smsText->length() ) )
            .arg(KMobileTools::EncodingsHelper::encodingNameString( KMobileTools::EncodingsHelper::hasEncoding(m_uiNewSMS->smsText->text(),
                 EnginesList::instance()->find(name(), false)->pdu()
                                                                                ) ) );
    statusBar->message(statusTexT);
}


/*!
    \fn newSMSDlg::pickPhoneNumber()
 */
void newSMSDlg::pickPhoneNumber()
{
    PickPhoneNumberDialog *dialog=new PickPhoneNumberDialog(this, name() );
    if(dialog->exec() != QDialog::Accepted ) return;
    if(!dialog->selectedNumbers().count() ) return;
    QStringList::iterator it;
    QStringList phonenumbers=dialog->selectedNumbers();
    for(it=phonenumbers.begin(); it!=phonenumbers.end(); ++it)
        addNumber(*it);
}

void newSMSDlg::addNumber( const QString &number)
{
    m_uiNewSMS->lv_numbers->clear();
    m_uiNewSMS->buttonAdd->setEnabled(false);
    sl_numbers+=number;
    QStringList::Iterator it;
    for(it=sl_numbers.begin(); it!= sl_numbers.end(); ++it)
        new KListViewItem(m_uiNewSMS->lv_numbers, *it, KMobileTools::KMobiletoolsHelper::translateNumber( *it ) );
}

const QString newSMSDlg::text()
{
    return m_uiNewSMS->smsText->text();
}


/*!
    \fn newSMSDlg::textNumberChanged()
 */
void newSMSDlg::textNumberChanged(const QString &text)
{
    if(text.length() ) m_uiNewSMS->buttonAdd->setEnabled(true);
    else m_uiNewSMS->buttonAdd->setEnabled(false);
}


/*!
    \fn newSMSDlg::NumberClicked(QListViewItem *)
 */
void newSMSDlg::NumberClicked(QListViewItem *item)
{
    if(item) m_uiNewSMS->buttonRemove->setEnabled(true);
    else m_uiNewSMS->buttonRemove->setEnabled(false);
}


/*!
    \fn newSMSDlg::remClicked()
 */
void newSMSDlg::remClicked()
{
    if(! m_uiNewSMS->lv_numbers->currentItem() ) return;
    sl_numbers.remove( m_uiNewSMS->lv_numbers->currentItem()->text(0) );
    delete m_uiNewSMS->lv_numbers->currentItem();
}


/*!
    \fn newSMSDlg::addClicked()
 */
void newSMSDlg::addClicked()
{
    addNumber(m_uiNewSMS->editNumber->text() );
}


/*!
    \fn newSMSDlg::slotUser1()
 */
void newSMSDlg::slotUser1()
{
    // User clicked "Send"
    createSMSItem();
    i_action=Send;
    done(Accepted);
}


/*!
    \fn newSMSDlg::slotUser2()
 */
void newSMSDlg::slotUser2()
{
    // User clicked "Store"
    createSMSItem();
    i_action=Store;
    done(QDialog::Accepted);
}

void newSMSDlg::createSMSItem()
{
//     kdDebug() << "newSMSDlg; numbers: " << sl_numbers << endl;
    p_sms=new SMS(sl_numbers, m_uiNewSMS->smsText->text() );
    p_sms->setType( SMS::Unsent );
}
