/***************************************************************************
   Copyright (C) 2007
   by Marco Gulino <marco@kmobiletools.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the
   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
 ***************************************************************************/
#include "engineloader.h"
#include <kdebug.h>
#include <kmessagebox.h>
#include <klibloader.h>
#include <unistd.h>
#include <qdir.h>
#include <qfile.h>
#include <kapplication.h>

#include "kmobiletoolsengine.h"

#include "config.h"
#ifdef NO_DEBUG
#warning **************************************************
#warning ** KMobileTools is still in a preliminary stage **
#warning ** Please use --enable-debug=full on configure  **
#warning **************************************************
#endif

using namespace ThreadWeaver;

DevicesInfoList::DevicesInfoList()
    : QObject(), QPtrList<DeviceInfos>(), probeDevicesNumber(0), probeDevicesDone(0), b_probing(false)
{
}

void DevicesInfoList::probeDevices( const QStringList &devicePaths, const QString &engineLib, const QStringList &params, bool fullprobe, int usleeptime, const QString &imeiToFind )
{
    sl_devicePaths=devicePaths;
    s_engineLib=engineLib;
    sl_params=params;
    b_fullprobe=fullprobe;
    i_usleeptime=usleeptime;
    setSearchingImei( imeiToFind );
    b_found=false;
    sl_devicesLocked.clear();
    clear();
    weaver=Weaver::instance();
    connect(weaver, SIGNAL(finished()), this, SLOT(slotDeviceProbeFinished() ) );
    connect(weaver, SIGNAL(jobDone( Job* )), this, SLOT(slotDeviceFound( Job* )) );
//     engineLoader *tempJob;
    probeDevicesNumber=devicePaths.count();
    probeDevicesDone=0;
    engineLoader *tempJob, *prevJob=0;
    KLibFactory *factory;
    lib=KLibLoader::self()->library(engineLib);
    if(lib) factory=lib->factory();
    else
    {
        factory=0;
        kdDebug() << "Couldn't load " << engineLib << ": " << KLibLoader::self()->lastErrorMessage() << endl;
    }

    if (factory)
    {
        engine = static_cast<kmobiletoolsEngine *>(factory->create(this, 0 , "kmobiletoolsEngine" ));
    }
    else
    {
        /// @TODO we're thread safe here, we can also add a dialog or a gui item to warn users...
        kdDebug() << "Last error: " << KLibLoader::self()->lastErrorMessage() << endl;
        return;
    }
    kdDebug() << "Probing devices:" << sl_devicePaths << endl;
    if(devicePaths.count()) b_probing=true;
    for( QStringList::ConstIterator cur=devicePaths.begin(); cur!=devicePaths.end(); ++cur )
    {
        tempJob=new engineLoader(this, engine, *cur, fullprobe, engineLib, params, usleeptime);
        if((*cur).contains("bluetooth://") )
        {
            if(prevJob) tempJob->addDependancy(prevJob);
            prevJob=tempJob;
        }
        connect(tempJob, SIGNAL(invalidLockFile( const QString& )), this, SLOT(invalidLockFile( const QString& )) );
        weaver->enqueue( tempJob );
    }
}

void DevicesInfoList::dump()
{
    DeviceInfos *item=0;
    QPtrListIterator<DeviceInfos> it(*this);
    int i=0;
    while( (item=it.current()) )
    {
        ++it;
        kdDebug() << "DevicesInfoList::dump(); item " << i << ": imei=" << item->imei() << "; " << item->rawManufacturer() << " " << item->model() << endl;
        i++;
    }
}



/*!
    \fn DevicesInfoList::invalidLockFile(const QString &lockFile)
 */
void DevicesInfoList::invalidLockFile(const QString &lockFile)
{
    /*
    QString device=QDir::cleanDirPath(lockFile).section( QDir::separator() , -1 ).replace( "LCK..", "");
    if( KMessageBox::questionYesNo( kapp->mainWidget(), i18n("<qt>KMobileTools has found that the device %1 is currently locked, but it seems that the application locking it has already exited.<br>This may happens when the application that was using this device has crashed.<br>Do you want KMobileTools to delete the lock file and load the device?</qt>") ) == KMessageBox::Yes ) QFile::remove( lockFile );*/
    if(sl_devicesLocked.findIndex( lockFile ) != -1) return;
    sl_devicesLocked+=lockFile;
}


void DevicesInfoList::slotDeviceFound( Job *job )
{
    if(job->jobOwner()!="engineloader") return;
    probeDevicesDone++;
    emit probePercentDone( (int) (((float)probeDevicesDone) / ((float)probeDevicesNumber) * 100)  );
    engineLoader *jobdone=(engineLoader*) job;
    if(!jobdone->deviceInfos()->isNull() )
        this->append( jobdone->deviceInfos() );
}

void DevicesInfoList::slotDeviceProbeFinished()
{
    if(!b_probing) return;
    b_probing=false;
//     if(sl_devicesLocked.isEmpty() )
    emit probeFinished();
//     delete engine;
    lib->unload();
    s_searchingIMEI=QString::null;
//     else
//     {
//         weaver->suspend( true );
//         QString device,lockFile;
//         engineLoader *tempJob;
//         QStringList::iterator lck=sl_devicesLocked.begin();
//         kdDebug() << "Probing devices, try 2\n";
//         while ( lck!= sl_devicesLocked.end() )
//         {
//             lockFile=*lck;
//             device=QDir::cleanDirPath(lockFile).section( QDir::separator() , -1 ).replace( "LCK..", "");
//             if( KMessageBox::questionYesNo( kapp->mainWidget(), i18n("<qt>KMobileTools has found that the device %1 is currently locked, but it seems that the application locking it has already exited.<br>This may happens when the application that was using this device has crashed.<br>Do you want KMobileTools to delete the lock file and load the device?</qt>").arg( device ) ) == KMessageBox::Yes )
//             {
//                 QFile::remove( lockFile );
//                 tempJob=new engineLoader( (sl_devicePaths.grep(device).first()) , b_fullprobe, s_engineLib, sl_params, i_usleeptime);
//                 connect(tempJob, SIGNAL(invalidLockFile( const QString& )), this, SLOT(invalidLockFile( const QString& )) );
// //                 sl_devicesLocked.remove( lck );
//                 weaver->enqueue( tempJob );
//             }
//             lck=sl_devicesLocked.remove( lck );
//         }
//         weaver->suspend( false );
//     }
}

DeviceInfos * DevicesInfoList::findByPath(const QString &path)
{
    QPtrListIterator<DeviceInfos> it(*this);
    DeviceInfos *foundItem;
    while( (foundItem=it.current()) )
    {
        ++it;
        if(foundItem->foundPath() == path ) return foundItem;
    }
    return 0;
}

DeviceInfos * DevicesInfoList::findByIMEI(const QString &imei)
{
    QPtrListIterator<DeviceInfos> it(*this);
    DeviceInfos *foundItem;
    while( (foundItem=it.current()) )
    {
        ++it;
        if(foundItem->imei() == imei ) return foundItem;
    }
    return 0;
}

engineLoader::~engineLoader()
{
}




engineLoader::engineLoader(DevicesInfoList* parent,  kmobiletoolsEngine *eng, const QString &devicePath, bool fullprobe, const QString &engineLib, const QStringList &params, int usleeptime )
    : ThreadWeaver::Job("engineloader")
{
    this->devicePath=devicePath; this->fullprobe=fullprobe; this->engineLib=engineLib; this->params=params; i_usleeptime=usleeptime;
    this->engine=eng;
    p_list=parent;
//     p_deviceInfos=0;
}

void engineLoader::run()
{
    if(p_list->found()) return;
//     while( !p_list->found() && p_deviceInfos.isNull() && i<2)
//     {
    p_deviceInfos=engine->probeDevice( this, true, devicePath, params );
//         if(p_deviceInfos.isNull())
//             thread()->msleep(200);
//         i++;
//     }
    if(p_deviceInfos.isNull() && i_usleeptime) thread()->msleep(i_usleeptime/1000);
    else if(p_list->searchingIMEI().length() && p_deviceInfos.imei()==p_list->searchingIMEI())
        p_list->setFound();
//     return engine->probeDevice( probetype, devicePath, param1, param2 );
}

#include "engineloader.moc"
