/***************************************************************************
   Copyright (C) 2007
   by Marco Gulino <marco@kmobiletools.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the
   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
 ***************************************************************************/
#include "homepage.h"

#include <khtml_part.h>
#include <qfile.h>
#include <kaboutdata.h>
#include <kiconloader.h>
#include <khtmlview.h>
#include <aboutdata.h>

#include <klocale.h>
#include <kstandarddirs.h>
#include <kapplication.h>
#include <qstringlist.h>
#include <kplugininfo.h>

#include "kmobiletoolsengine.h"
#include "kmobiletools_devices.h"
#include "kmobiletools_cfg.h"
#include "devicemenu.h"
#include "mainIFace_stub.h"

#include <iostream>
using namespace std;

homepagePart::homepagePart(QWidget *parent, const char *name)
 : KHTMLPart(parent, name, parent, "homepagepart")
        , i_infopage(-1), p_engine(0)
{
    view()->setSizePolicy(QSizePolicy(QSizePolicy::Expanding,QSizePolicy::Expanding, 5, 2) );
    connect( browserExtension(), SIGNAL( openURLRequest(const KURL &, const KParts::URLArgs &) ),
             this, SLOT( openURLRequest(const KURL &) ) );
    connect( this, SIGNAL(popupMenu(const QString &, const QPoint &) ),
             this, SLOT(slotContextMenu(const QString&, const QPoint& ) ) );
//     openURL("http://www.kde.org");
//     setupHP();
    setStatusMessagesEnabled(true);
}


homepagePart::~homepagePart()
{
    end();
}


#include "homepage.moc"

/*!
    \fn homepagePart::refreshData()
 */
void homepagePart::refreshData(const QString &data)
{
    QString location = locate( "data", "kmobiletools/about/main.html" );
    QFile fcontent(location);
    fcontent.open(IO_ReadOnly);
    content = QString(fcontent.readAll() );
    fcontent.close();
    content = content.arg( locate( "data", "kmobiletools/about/kde_infopage.css" ) );
//     if ( kapp->reverseLayout() )
//         content = content.arg( "@import \"%1\";" ).arg( locate( "data", "kmobiletools/about/kde_infopage_rtl.css" ) );
//     else
         content = content.arg( "" );
    begin( KURL( location ) );

    QString appName( i18n( "KMobileTools" ) );
    QString catchPhrase( i18n( "Get Synced!" ) );
    QString quickDescription( i18n( "a KDE Mobile Phone Syncing and Management tool" ) );
    content=content.arg( QFont().pointSize() + 2 ).arg( appName )
            .arg( catchPhrase ).arg( quickDescription ).arg( data );
    write( content );
    end();
//     cout << content << "\n";
}


/*!
    \fn homepagePart::openURLRequest(const KURL &url, const KParts::URLArgs &args=KParts::URLArgs())
 */
void homepagePart::openURLRequest(const KURL &url)
{
    if(url.protocol() == "mobile")
        emit switchDevice( url.path() );
    if(url.protocol() == "config")
        emit configCmd( url.path() );
    if(url.protocol() == "infopage")
        emit infopage ( url.path().toInt() );
    if(url.protocol().contains("device") )
        emit deviceCMD( url );
}

void homepagePart::printIndexPage()
{
    QString htmlData;
    htmlData="<h4 style='text-align:center; margin-top: 0px;'>%1 %2</h4>\
            <table align=\"center\">\n";
    htmlData=htmlData.arg( i18n("Welcome to KMobileTools")).arg(AboutData().version() );
    QStringList devices=KMobileTools::MainConfig::devicelist();
    if( ! (devices.count()) ) /// Assuming that the first part is always the homepage
    {
        htmlData+="<tr><td align=\"left\">%1</td></tr>\n";
        htmlData+="<tr><td align=\"left\"><a href=\"config:newDevWiz\">\n\t<img src=\"%2\" align=\"absmiddle\"> <b>%3</b></a></td></tr>\
                <tr><td align=\"left\"><a href=\"config:configDevices\">\n\t<img src=\"%3\" align=\"absmiddle\"> <b>%4</b></a></td></tr>";
        htmlData=htmlData.arg( i18n("KMobileTools handles your mobile phone devices, can read, write and send sms, synchronize your addressbook, and much more") )
                .arg( KGlobal::iconLoader()->iconPath("wizard", -KIcon::SizeHuge) )
                .arg( i18n("Add a new mobile phone device") )
                .arg( KGlobal::iconLoader()->iconPath("blockdevice", -KIcon::SizeHuge) )
                .arg( i18n("Configure devices") );
    } else
    for(QStringList::Iterator it = devices.begin(); it != devices.end(); ++it )
    {
        htmlData+="<a href=\"mobile:%3\"><img src=\"%1\" align=\"left\" style=\"background-image : url('%4');\"><p><font size=\"+1\">&nbsp;&nbsp;%2</font></p><p>&nbsp;&nbsp;%3</p><br clear=\"ALL\"></a><br>";
        QString iconDev;
        KPluginInfo *infos=EnginesList::instance()->engineInfo( DeviceConfigInstance(*it)->engine() );
        if(infos) iconDev=infos->icon();
        kdDebug() << "Loaded icon: " << iconDev << endl;

        MainIFace_stub *mainStub=new MainIFace_stub(kapp->dcopClient(), "kmobiletools", "KMobileTools" );
        bool isLoaded=mainStub->deviceIsLoaded( *it );
//         if( !isLoaded ) iconDev.append("_d");
        QString iconBG;
        if ( !isLoaded ) iconBG = "closedphone"; else iconBG="kmobiletools";
        QString stringStatus;
        if( isLoaded )
        {
            deviceIFace=new DeviceIFace_stub( kapp->dcopClient(), "kmobiletools", QCString((*it).latin1() ) );
            if ( deviceIFace->isConnected() )
                stringStatus=i18n("Device connected");
            else
            {
                stringStatus=i18n("Device disconnected");
                iconDev="overlaydisc";
            }
            delete deviceIFace;
        }
        else stringStatus=i18n("Not loaded");
        htmlData=htmlData.arg( KGlobal::iconLoader()->iconPath(iconDev, -KIcon::SizeHuge) )
            .arg( DeviceConfigInstance(*it)->devicename() )
            .arg(KURL::encode_string_no_slash( *it ) )
            .arg( stringStatus )
            .arg( KGlobal::iconLoader()->iconPath(iconBG, -KIcon::SizeHuge) );

        htmlData+="</p>\n";
        delete mainStub;
    }
    htmlData+="</table>";
    refreshData(htmlData);
}

void homepagePart::printInfoPage(int i, kmobiletoolsEngine *engine)
{
    if(!engine) return;
    printInfoPage(i, DeviceConfigInstance(engine->name())->devicename(), engine);
}

void homepagePart::printInfoPage(int i, const QString &mobileName, kmobiletoolsEngine *engine)
{
    p_engine=engine;
    i_infopage=i;
    QString htmlData;
    htmlData="<h2 style='text-align:center; margin-top: 0px;'><img src=\"%1\" align=\"absmiddle\"> %2</h2>";
    htmlData=htmlData.arg(KMobileTools::DevicesConfig::deviceTypeIconPath(name(),-KIcon::SizeHuge) )
                     .arg( mobileName );

    switch( i ){
    case 1:
        htmlData+="<ul><li><b>%1</b></li></ul>";
        htmlData=htmlData.arg(i18n("Phone details") );
        htmlData+="<p><b>%1</b> %2</p><p><b>%3</b> %4</p><p><b>%5</b> %6</p><p><b>%7</b> %8</p><div align='right'><a href=\"infopage:0\">%9</a></div>";
        htmlData=htmlData.arg(i18n("Manufacturer: ") ).arg(engine->rawManufacturer() )
            .arg(i18n("Model: ") ).arg(engine->model() )
            .arg(i18n("IMEI: ") ).arg(engine->imei() )
            .arg(i18n("Revision: ") ).arg(engine->revision() )
            .arg(i18n("Phone overview") );
        break;
    case 2:
        htmlData+="<center><b>%1</b></center><br><br>%3<br><br><br><center><img src=\"%2\"></center><br>";
        htmlData=htmlData
                .arg(i18n("Searching Mobile Phone") )
                .arg(KGlobal::dirs ()->findResource("data", "kmobiletools/progress.gif") )
                .arg(i18n("Please wait while KMobileTools tries to find the right device for your mobile phone.") );
        break;
    default:
        if( engine->isConnected() )
        {
            SMSList *l=engine->smsList();
            htmlData+="<ul><li><b>%8</b></li></ul><p>%1 %2</p><p>%3 %4</p><div align='right'><a href=\"infopage:1\">%7</a></div>";
            htmlData=htmlData
                    .arg( QString("<a href=\"%1:sms\">").arg(engine->name()) +
                    htmlIcon("mail_get",-KIcon::SizeSmallMedium) )
                    .arg(i18n("%1 received SMS (%2 unread).")
                    .arg( QString::number( l->count( SMS::Unread | SMS::Read, SMS::Phone | SMS::SIM) ) )
                    .arg( QString::number( l->count( SMS::Unread, SMS::Phone | SMS::SIM) ) ) + "</a>")
//                     .arg( htmlIcon("phonecall",-KIcon::SizeSmallMedium) ).arg("No new calls")
                    .arg(  QString("<a href=\"%1:phonebook\">").arg(engine->name()) + htmlIcon("personal",-KIcon::SizeSmallMedium) )
                    .arg(i18n("%1 contact stored in phonebook.", "%1 contacts stored in phonebook.", engine->addresseeList()->count())
                    .arg(engine->addresseeList()->count() ) ) + "</a>";
        } else
        {
            htmlData+="<ul><li><b>%8</b></li></ul><p>%1 %2</p><p>%3 %4</p><div align='right'><a href=\"infopage:1\">%7</a></div>";
            htmlData=htmlData
                    .arg(htmlIcon("stop",-KIcon::SizeSmallMedium) )
                    .arg(QString("<a href=\"%1:tryconnect\">%2</a>").arg(engine->name()).arg(i18n("Device disconnected. Click here to retry connect.") ) )
                    .arg(htmlIcon("configure",-KIcon::SizeSmallMedium) )
                    .arg(QString("<a href=\"%1:configure\">%2</a>").arg(engine->name()).arg(i18n("Click here to configure this mobile phone.") ) );
        }
        htmlData=htmlData.arg(i18n("Phone details") )
                .arg(i18n("Phone overview") );
        break;
    }
    refreshData( htmlData );
}

const QString homepagePart::htmlIcon(const QString &iconName, int groupOrSize)
{
    return KGlobal::iconLoader()->iconPath(iconName, groupOrSize, false)
    .prepend("<img align=\"absmiddle\" src=\"").append("\">");
}


/*!
    \fn homepagePart::slotContextMenu(const QString& urlString, const QPoint& point )
 */
void homepagePart::slotContextMenu(const QString& urlString, const QPoint& point )
{
    kdDebug() << "homepagePart::slotContextMenu(\"" << urlString << "\", " << point << ") engine:" << p_engine <<";\n";
    KURL url(urlString);
//     if(urlString==QString::null && p_engine) url=KURL::fromPathOrURL( QString("mobile:%1").arg(p_engine->name() ));
    KPopupMenu *m_popup=0;
    if(url.protocol() == "mobile" || p_engine)
    {
        bool eng_loaded;
        QString eng_name;
        if(!p_engine)
        {
            eng_loaded=(EnginesList::instance()->namesList(false).contains(url.path() )>0);
            eng_name=url.path();
        } else
        {
            eng_loaded=true;
            eng_name=p_engine->name();
        }
        m_popup=new deviceMenu( eng_loaded, p_engine, 0, eng_name.latin1() );
        connect(m_popup, SIGNAL(switchDevice(const QString &) ), SIGNAL(switchDevice(const QString &) ) );
        connect(m_popup, SIGNAL(loadDevice(const QString &) ), SIGNAL(loadDevice(const QString &) ) );
        connect(m_popup, SIGNAL(unloadDevice(const QString &) ), SIGNAL(unloadDevice(const QString &) ) );
        connect(m_popup, SIGNAL(configure(const QString &) ), SIGNAL(configCmd(const QString &)) );
        connect(m_popup, SIGNAL(sendURL(const KURL&) ), this, SLOT(openURLRequest(const KURL&) ) );
    }
    if( ! m_popup ) return;
    m_popup->exec(point);
}

void homepagePart::guiActivateEvent( KParts::GUIActivateEvent *event )
{
    KHTMLPart::guiActivateEvent(event);
    emit setStatusBarText( QString("KMobileTools") );
}

void homepagePart::partActivateEvent( KParts::PartActivateEvent *event )
{
    kapp->sendEvent(this, (new KParts::GUIActivateEvent( event->activated() ) )  );
}
