/***************************************************************************
   Copyright (C) 2007
   by Marco Gulino <marco@kmobiletools.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the
   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
 ***************************************************************************/
#include "keycombobox.h"
#include <qmap.h>
#include <kdebug.h>

class KeyComboBoxPrivate
{
    public:
        KeyComboBoxPrivate() {};
        QMap<QString,QString> keywords;
};

KeyComboBox::KeyComboBox(bool rw, QWidget* parent, const char* name): KComboBox(rw, parent, name)
{
    d=new KeyComboBoxPrivate;
}


KeyComboBox::KeyComboBox(QWidget* parent, const char* name): KComboBox(parent, name)
{
    d=new KeyComboBoxPrivate;
}


KeyComboBox::~KeyComboBox()
{
}

void KeyComboBox::insertItem(const QString &text, const QString &keyword)
{
//     kdDebug() << "KeyComboBox::insertItem(" << text << ", " << keyword << ");\n";
    KComboBox::insertItem(text);
    d->keywords.insert(text, keyword);
}

QString KeyComboBox::currentKeyword() const
{
//     kdDebug() << "KeyComboBox::currentKeyword(); returning " << d->keywords[currentText()] << endl;
    return d->keywords[currentText()];
}

QString KeyComboBox::keyword(int index) const
{
    return d->keywords[text(index)];
}

void KeyComboBox::setCurrentKeyword(const QString &keyword)
{
//     kdDebug() << "KeyComboBox::setCurrentKeyword(" << keyword << ")\n";
    for(int i=0; i<count(); i++)
    {
        kdDebug() << this->keyword(i) << "==" << keyword << "?\n";
        if(this->keyword(i)==keyword) setCurrentItem(i);
    }
//     d->keywords.replace(currentText(), keyword);
}

void KeyComboBox::setKeyword(int index, const QString &keyword)
{
    d->keywords.replace(text(index), keyword);
}


#include "keycombobox.moc"
