/***************************************************************************
   Copyright (C) 2007
   by Marco Gulino <marco@kmobiletools.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the
   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
 ***************************************************************************/
#include "kmobiletoolsengine.h"
#include <kplugininfo.h>

#include "config.h"

using namespace KMobileTools;


kmobiletoolsJob::kmobiletoolsJob (const QString &owner, QObject* parent, const char* name)
    : ThreadWeaver::Job(owner, parent,name), ji_percent(0)
{
    connect(this, SIGNAL(SPR()), this, SLOT(slotPercentDone()));
}

kmobiletoolsJob::kmobiletoolsJob (kmobiletoolsJob *pjob, QObject* parent , const char* name)
    : ThreadWeaver::Job(pjob, parent,name), ji_percent(0)
{
    connect(this, SIGNAL(SPR()), this, SLOT(slotPercentDone()));
}

void kmobiletoolsJob::slotPercentDone()
{
//     kdDebug() << "*****slotPercentDone with percentDone==" << ji_percent << endl;
    if(!ji_percent) return;
    emit percentDone(ji_percent);
    ji_percent=0;
}

void kmobiletoolsJob::slotPercentDone(int p)
{
//     kdDebug() << "|||||Calling triggerSPR with percentDone==" << p << endl;
    ji_percent=p;
    triggerSPR();
}

void kmobiletoolsEngine::processSlot(Job* job)
{
    if( ! job->inherits("kmobiletoolsJob")) return;
    kmobiletoolsJob *kjob=(kmobiletoolsJob*) job;
    emit jobFinished(kjob->type() );
}

kmobiletoolsEngine::kmobiletoolsEngine( QObject *parent, const char *name)
    : QObject(parent,name)
{
//     b_ownweaver=ownWeaver;
    /*if(ownWeaver) */weaver=new ThreadWeaver::Weaver(this, name, 2, 2);
//     else weaver=ThreadWeaver::Weaver::instance();
    p_smsList=new SMSList(name);
    p_diffSMSList=new SMSList();
    connect(weaver, SIGNAL(jobDone(Job*) ), SLOT(processSlot(Job*) ) );
    connect(weaver, SIGNAL(suspended() ), this, SLOT(weaverSuspended() ) );
    connect(p_smsList, SIGNAL(added( const QCString& )), SIGNAL(smsAdded( const QCString& ) ));
    connect(p_smsList, SIGNAL(removed( const QCString& )), SIGNAL(smsDeleted( const QCString& )));
    connect(p_smsList, SIGNAL(modified( const QCString& )), SIGNAL(smsModified( const QCString& )));
    connect(&devicesList, SIGNAL(probeFinished() ), this, SLOT(initPhone()) );
    connect(this, SIGNAL(connected()), this, SLOT(devConnected() ));
    connect(this, SIGNAL(disconnected()), this, SLOT(devDisconnected()));
    i_manufacturer = Unknown;
    p_addresseeList = new ContactPtrList();
    s_newSMS = 0;
    s_totalSMS = 0;
    i_suspendStatusJobs=0;
    p_foundDevice=0;
    EnginesList::instance()->append( this );
    b_connected=false;
#ifdef HAVE_KCAL
            p_calendar=new Calendar();
#endif
}

kmobiletoolsEngine::~kmobiletoolsEngine()
{
    kdDebug() << "kmobiletoolsEngine::~kmobiletoolsEngine()\n";
//     weaver->dequeue();
//     weaver->finish();
//     delete weaver;
//     weaver=NULL;

//     delete p_addresseeList;
    delete p_diffSMSList;
    delete p_smsList;
#ifdef HAVE_KCAL
    delete p_calendar;
#endif
    EnginesList::instance()->remove( this );
}

void kmobiletoolsEngine::queryClose()
{
    kdDebug() << "kmobiletoolsEngine::queryClose()\n";
//     if(!ownWeaver) return;
    weaver->dequeue();
    weaver->suspend( true );
    weaver->finish();
    delete weaver;
    weaver=NULL;
}

void kmobiletoolsEngine::enqueueJob(kmobiletoolsJob *job)
{
    weaver->enqueue(job);
    emit jobEnqueued(job);
}

void kmobiletoolsEngine::switchToFSMode()
{
    stopDevice();
}


const QString kmobiletoolsJob::typeString()
{
    switch( type() ){
        case kmobiletoolsJob::initPhone:
            return i18n("Connecting to the Phone");
        case pollStatus:
            return i18n("Fetching Phone Status");
        case fetchSMS:
            return i18n("Fetching SMS");
        case fetchAddressBook:
            return i18n("Fetching PhoneBook");
        case fetchPhoneInfos:
            return i18n("Fetching Phone Informations");
        case testPhoneFeatures:
            return i18n("Testing Phone Capabilities");
        case syncDateTimeJob:
            return i18n("Syncing Date and Time");
        case selectSMSSlot:
            return i18n("Changing SMS Memory Slot");
        case selectCharacterSet:
            return i18n("Changing Character Set");
        case sendSMS:
            return i18n("Sending SMS");
        case storeSMS:
            return i18n("Storing SMS");
        case addAddressee:
            return i18n("Adding Contacts");
        case delAddressee:
            return i18n("Deleting Contacts");
        case editAddressee:
            return i18n("Modifying Contacts");
        case smsFolders:
            return i18n("Getting SMS Folders");
        case delSMS:
            return i18n("Deleting SMS");
        case fetchKCal:
            return i18n("Fetching Calendar Events");
        case sendStoredSMS:
            return i18n("Sending SMS from Storage");
        default:
            return i18n("Unknown Job");
    }
}

KPluginInfo *kmobiletoolsEngine::pluginInfo()
{
    return EnginesList::instance()->engineInfo(engineLibName(), true );
}

QString kmobiletoolsEngine::shortDesc()
{
    return pluginInfo()->comment();
}

QString kmobiletoolsEngine::longDesc()
{
    return pluginInfo()->property("X-KMobileTools-LongDesc").toString();
}

