/***************************************************************************
   Copyright (C) 2007
   by Marco Gulino <marco@kmobiletools.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the
   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
 ***************************************************************************/
#include "picksmscenter.h"
#include "kmobiletoolshelper.h"

#include <klocale.h>
#include <kconfig.h>
#include <qvbox.h>
#include <kdeversion.h>
#include <klistviewsearchline.h>
#include <klistview.h>
#include <kglobal.h>
#include <kstandarddirs.h>
#include <kmessagebox.h>


PickSMSCenter::PickSMSCenter(QWidget *parent, const char *name)
    : KDialogBase(parent, name, true, i18n( "Pick SMS Center from list", "Choose Your Operator SMS Center"), Ok | Cancel )
{
    enableButtonOK (false);
    vbox=new QVBox(this, name);
#if KDE_IS_VERSION( 3, 4, 0 )
    KListViewSearchLineWidget *slwidget=new KListViewSearchLineWidget( 0, vbox);
#else
    KListViewSearchLine *slwidget=new KListViewSearchLine( vbox, 0 );
#endif
    listview=new KListView(vbox);
    listview->addColumn( i18n("Network name for SMS Center", "Network Name") );
    listview->addColumn( i18n("SMS Center number", "Number") );
    connect(listview, SIGNAL(clicked( QListViewItem* )), this, SLOT(clicked( QListViewItem* ) ) );
    connect(listview, SIGNAL(doubleClicked( QListViewItem*, const QPoint&, int ) ), this, SLOT(doubleClicked( QListViewItem*, const QPoint&, int )) );
#if KDE_IS_VERSION( 3, 4, 0 )
    slwidget->createSearchLine(listview);
#else
    slwidget->setListView(listview);
#endif
    setMainWidget( vbox);
    resize(400,500);
    initList();
}


PickSMSCenter::~PickSMSCenter()
{
}


#include "picksmscenter.moc"


/*!
    \fn PickSMSCenter::initList()
 */
void PickSMSCenter::initList()
{
    QString file=KGlobal::dirs()->findResource( "data", "kmobiletools/operatorsdata" );
    if(file==QString::null)
    {
        KMessageBox::error( this, i18n("Operators data not found.") );
        return;
    }

    config=new KConfig( file, true );
    QStringList operators=config->groupList();
    for(QStringList::Iterator it=operators.begin(); it!=operators.end(); ++it)
    {
        config->setGroup( *it );
        if(config->readEntry( "smscenter") == QString::null ) continue;
        new KListViewItem(listview, *it, config->readEntry( "smscenter") );
    }
    delete config;
}


/*!
    \fn PickSMSCenter::clicked ( QListViewItem * item )
 */
void PickSMSCenter::clicked ( QListViewItem * item )
{
    if(!item )
    {
        enableButtonOK(false);
        s_smsCenter=QString::null;
        return;
    }
    enableButtonOK( true );
    s_smsCenter=item->text(1);
}


/*!
    \fn PickSMSCenter::doubleClicked( QListViewItem *, const QPoint &, int )
 */
void PickSMSCenter::doubleClicked( QListViewItem *item, const QPoint &, int )
{
    clicked(item);
    if(!item)return;
    done(Accepted);
}


/*!
    \fn PickSMSCenter::smsCenterName(const QString &smsCenter)
 */
QString PickSMSCenter::smsCenterName(const QString &smsCenter)
{
    QString file=KGlobal::dirs()->findResource( "data", "kmobiletools/operatorsdata" );
    if(file==QString::null) return smsCenter;

    KConfig *config=new KConfig( file, true );
    QStringList operators=config->groupList();
    for(QStringList::Iterator it=operators.begin(); it!=operators.end(); ++it)
    {
        config->setGroup( *it );
        if( KMobileTools::KMobiletoolsHelper::compareNumbers( config->readEntry( "smscenter"), smsCenter ) )
        {
            delete config;
            return *it;
        }
    }
    delete config;
    return smsCenter;
}
