/***************************************************************************
   Copyright (C) 2007
   by Marco Gulino <marco@kmobiletools.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the
   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
 ***************************************************************************/
#include "popupsms.h"
#include <kglobal.h>
#include <kiconloader.h>
#include <kdebug.h>
#include <klocale.h>

#define SEND_ID 1
#define DELETE_ID 2

popupSMS::popupSMS(SMS *sms, QWidget *parent, const char *name)
    : KPopupMenu(parent,name)
{
    p_sms=sms;
    insertTitle( KGlobal::iconLoader()->loadIcon( "mail_generic", KIcon::Small, KIcon::SizeSmall ), i18n("SMS") );
    insertItem(  KGlobal::iconLoader()->loadIconSet("editdelete", KIcon::Small, KIcon::SizeSmall),
                 i18n("Delete"), DELETE_ID);
    connect(this, SIGNAL(activated(int) ), this, SLOT(activated(int ) ) ); 
}


popupSMS::~popupSMS()
{
}


#include "popupsms.moc"

/*!
    \fn popupSMS::activated(int id)
 */
void popupSMS::activated(int id)
{
    switch( id ){
        case DELETE_ID:
            emit remove( p_sms );
            break;
    }
}
