/***************************************************************************
   Copyright (C) 2007
   by Marco Gulino <marco@kmobiletools.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the
   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
 ***************************************************************************/
#ifndef SMS_H
#define SMS_H

#include <qobject.h>
#include <qstringlist.h>
#include <qdatetime.h>
#include <kmdcodec.h>
#include <qcstring.h>

/**
@author Marco Gulino
*/

class SMS : public QObject
{
Q_OBJECT
public:
    SMS(QObject *parent = 0, const char *name = 0);
    SMS(const QStringList & numbers, const QString & text, QObject *parent = 0, const char *name = 0);
    SMS(const QStringList & numbers, const QString & text, const QDateTime & datetime, QObject *parent = 0, const char *name = 0);

    ~SMS();

    enum MemorySlot
    { SIM=0x1, Phone=0x2, Unknown=0x10 };
    enum SMSType
    { Unread=0x1, Read=0x2, Unsent=0x4, Sent=0x8, All=0xA };
    static const QString SMSTypeString(SMSType smstype) {
        switch (smstype) {
                case SMS::Unread:
                return "REC UNREAD";
                case SMS::Read:
                return "REC READ";
                case SMS::Unsent:
                return "STO UNSENT";
                case SMS::Sent:
                return  "STO SENT";
                case SMS::All:
                return "ALL";
        }
        return QString::null;
}

    static int SMSIntType (QString type) {
        if (type==QString("REC UNREAD")) return SMS::Unread;
        if (type==QString("REC READ")) return SMS::Read;
        if (type==QString("STO UNSENT")) return SMS::Unsent;
        if (type==QString("STO SENT")) return SMS::Sent;
        if (type==QString("ALL")) return SMS::Sent;
        return -1;
}
    bool isIncoming() { return ((type() & Unread) || (type() & Read)); }
    void setText(const QString & text) { s_text=text; }
    virtual QString getText() const { return s_text; }
    virtual QStringList getMultiText() const;
    static QStringList getMultiText(const QString&);
    static int getMultiTextCount(const QString&);
    static int getMultiTextCount(int);
    virtual QString getFrom() const;
    virtual QStringList getTo() const;
    virtual QString getDate() const { return dt_datetime.toString(); }
    virtual QDateTime getDateTime() const { return dt_datetime; }
    virtual void setRawSlot(const QString &rawSlot){ s_rawSlot=rawSlot;}
    virtual const QString rawSlot(){ return s_rawSlot;}
    void setNumbers(const QStringList & numbers) { sl_numbers=numbers; };
    void setDateTime(const QDateTime & datetime);

    void setFolder( int newFolder ) { i_folder = newFolder; }
    int folder() { return i_folder; };
    QValueList<int> *idList() { return &v_id; };
//     void setId( int newId ) { i_id = newId; };

    void setSlot( int newSlot ) { i_slot=newSlot; emit updated(); }
    SMSType type() { return i_type; };
    void setType( SMSType newType ) { i_type = newType; emit updated(); };
    int slot() { return i_slot; }
    const QCString uid() 
    {
        KMD5 context;
        if (sl_numbers.isEmpty()) context.update( s_text.utf8() );
        else context.update((s_text + sl_numbers.join(",") ).utf8());
        return context.hexDigest();
    }
    bool operator ==(SMS* compSMS);
    bool unread() { return b_unread; }
    void setUnread(bool unread) { b_unread=unread;}
protected:
    QStringList sl_numbers;
    QString s_text;
    QDateTime dt_datetime;
    int i_folder, i_slot;
    SMSType i_type;
    QValueList<int> v_id;
    QString s_rawSlot;
    bool b_unread;

public slots:
    bool exportMD(const QString &dir);
    bool writeToSlot( const QString &slotDir);
    bool exportCSV(const QString &dir, const QString &filename);
    bool writeToSlotCSV( const QString &slotDir, const QString &filename);
signals:
    void updated();
};

#endif
