/***************************************************************************
   Copyright (C) 2007
   by Marco Gulino <marco@kmobiletools.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the
   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
 ***************************************************************************/
#ifndef BLUETOOTHITEMS_H
#define BLUETOOTHITEMS_H

#include "config.h"
#if defined (KBLUETOOTH) || defined (KBLUETOOTH_NEW)
#define HAVE_KBLUETOOTH 1
#endif
#include <klistview.h>

#include <qstring.h>
#ifdef KBLUETOOTH
#include <kdebluetooth/inquiry.h>
#include <kdebluetooth/hcisocket.h>
#include <kdebluetooth/sdpdevice.h>
#endif

#ifdef KBLUETOOTH

class BtDeviceItem : public KListViewItem
{
public:
    BtDeviceItem(KListView *parent, const KBluetooth::DeviceAddress &bdaddr);
    KBluetooth::DeviceAddress bdAddr() const;
    KBluetooth::SDP::Device *device();
private:
    KBluetooth::DeviceAddress m_bdaddr;
    KBluetooth::SDP::Device m_device;
};

class BtServiceItem : public KListViewItem
{
public:
    BtServiceItem(KListView *parent, KBluetooth::SDP::Service *svc, const KBluetooth::DeviceAddress &bdaddr);
    KBluetooth::SDP::Service *service();
    KBluetooth::DeviceAddress bdAddr() const;

private:
    KBluetooth::DeviceAddress m_bdaddr;
    KBluetooth::SDP::Service *p_svc;
};
#else
namespace KBluetooth {
    class DeviceAddress;
}
#endif
#ifdef KBLUETOOTH_NEW
#include <libkbluetooth/servicerecord.h>

class RemoteDevice;
class BtDeviceItem : public KListViewItem
{
public:
    BtDeviceItem(KListView *parent, const QString &address, const QString &name);
    QString address() const { return b_addr; }
    QString name() const { return b_name; }
    void setAddress(const QString &addr);
    void setName(const QString &name);
    RemoteDevice *device();
    void setDevice(RemoteDevice*);
private:
    QString b_addr;
    QString b_name;
    RemoteDevice *dev;
};

class BtServiceItem : public KListViewItem
{
public:
    BtServiceItem(KListView *parent, const KBluetooth::ServiceRecord& service);
    KBluetooth::ServiceRecord p_service;
    RemoteDevice *device;
};
#endif

#endif
