/***************************************************************************
   Copyright (C) 2007
   by Marco Gulino <marco@kmobiletools.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the
   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
 ***************************************************************************/
#include "newdevicewizard.h"

#include <qtabwidget.h>
#include <kpushbutton.h>
#include <math.h>
#include <keditlistbox.h>
#include <klocale.h>
#include <qbuttongroup.h>
#include <kdebug.h>
#include <engineloader.h>
#include <klineedit.h>
#include <klistview.h>
#include <qlabel.h>
#include <kprogress.h>
#include <qcheckbox.h>
#include <unistd.h>
#include <kcombobox.h>
#include <kmessagebox.h>
#include <kglobal.h>
#include <kstandarddirs.h>
#include <kprogress.h>
#include <kmessagebox.h>
#include <knuminput.h>
#include <krun.h>
#include <kiconloader.h>
#include <kactivelabel.h>
#include <qradiobutton.h>
#include <kplugininfo.h>
#include <qwidgetstack.h>
#ifdef HAVE_KBLUETOOTH
#define useBT (selBT && ( BTItem || !manualSVC->isChecked() ) )
#define selBT ( btenable->isOn())
#define BTItem ((BtServiceItem*)btsvcLV->selectedItem())
#else
#define selBT false
#define useBT false
#endif
#ifdef KBLUETOOTH
#include <kdebluetooth/namerequest.h>
#endif
#ifdef KBLUETOOTH_NEW
#include "bluemonitor.h"
#endif

#include "kmobiletools_devices.h"
#include "kmobiletoolshelper.h"
#include "kmobiletoolsengine.h"
#include "engineloader.h"
#include "deviceconfigdialog.h"
#include "keycombobox.h"
#include "picksmscenter.h"
#include "bluetoothitems.h"


#define CONN_USB            1
#define CONN_USB_ID         0
#define CONN_IRDA           2
#define CONN_IRDA_ID        1
#define CONN_BLUETOOTH      4
#define CONN_BLUETOOTH_ID   2
#define CONN_SERIAL         8
#define CONN_SERIAL_ID      3

#define AT_BLUETOOTH_PAGE   1

#define AT_DEVICE_PAGE      2
#define AT_DEVICESLIST      3
#define AT_DEVICESLOTS      4
#define LAST_PAGE           5

using namespace KMobileTools;
newDeviceWizard::newDeviceWizard(QWidget *parent, const char *name)
    : ui_newdevicewizard(parent, name), enginetype(0), probed(false), classicDialog(false)
{
    connect( b_advopts_details, SIGNAL(clicked() ), this, SLOT(at_advancedOptions() ) );
    connect( bg_devtype, SIGNAL(clicked( int ) ), this, SLOT(at_connectionClicked( int ) ));
    connect( this, SIGNAL(selected( const QString & ) ), this, SLOT(selected( const QString &) ) );
    connect( mobilesList, SIGNAL(clicked( QListViewItem* ) ), this, SLOT( at_deviceClicked( QListViewItem*) ) );
    connect( btStatusLabel, SIGNAL(linkClicked(const QString&) ), this, SLOT(btWizard()) );
    connect( permwizard, SIGNAL(clicked()), this, SLOT( permissionWizard() ));
    connect( engineSelection, SIGNAL(activated(const QString &) ), this, SLOT(engineSelected( const QString & )) );

    connect( lv_smsSlots, SIGNAL(clicked ( QListViewItem * )), this, SLOT(checkAdvParams()) );
    connect( lv_pbslots, SIGNAL(clicked ( QListViewItem * )), this, SLOT(checkAdvParams()) );
    connect( kcfg_at_encoding_2, SIGNAL(textChanged ( const QString & )), this, SLOT(checkAdvParams()) );
    connect( smsCenter, SIGNAL(textChanged ( const QString & )), this, SLOT(checkAdvParams()) );
    connect( b_skipWizard, SIGNAL(clicked() ), this, SLOT(skipWizard() ) );
    connect(btenable, SIGNAL(toggled ( bool)), this, SLOT(bt_checked( bool )));
#ifdef HAVE_KBLUETOOTH
    connect( btDevicesLV, SIGNAL(clicked(QListViewItem*)), this, SLOT(btDeviceClicked(QListViewItem*)));
    connect( btsvcLV, SIGNAL(clicked(QListViewItem*)), this, SLOT(btServiceClicked(QListViewItem*)));
    connect( manualSVC, SIGNAL(toggled(bool)), this, SLOT(slotManualServices(bool)));
    c_blue->hide();
#ifdef KBLUETOOTH
    inquiry=NULL;
    btSocket=NULL;
#endif
#ifdef KBLUETOOTH_NEW
    monitor=0;
#endif

#else
    connect( btwizard, SIGNAL(clicked()), this, SLOT(btWizard()));
#endif

    advoptstab->hide();
    b_advopts_details->setText(i18n("Details >>"));
    advoptstab->resize( 0,0 );
//     resize( 400,500 );
    at_selected_connections=0;
    s_deviceName=name;

    ///TODO We should remove this, and set up better each widget costraints.
    setFinishEnabled(page(LAST_PAGE), true);

//     c_ser->setChecked(true); at_connectionClicked(CONN_SERIAL_ID);
    QPixmap wizardLogoPixmap;
    wizardLogoPixmap.load( KGlobal::dirs ()->findResource("data", "kmobiletools/kmobilewizard.png") );
    wizardLogo->setPixmap( wizardLogoPixmap );
    wizardLogoPixmap.load( KGlobal::dirs ()->findResource("data", "kmobiletools/kmobilebtwizard.png") );
    btLogo->setPixmap( wizardLogoPixmap );
    wizardLogoPixmap.load( KGlobal::dirs ()->findResource("data", "kmobiletools/security.png") );
    permwizard->setIconSet(QIconSet (wizardLogoPixmap) );
    b_skipWizard->setIconSet(KGlobal::iconLoader()->loadIconSet("cancel", KIcon::Small) );
//     resize(minimumSize () );
    newDevicesList=new DevicesInfoList();
    connect(newDevicesList, SIGNAL(probeFinished() ), this, SLOT(devicesProbed() ) );
    connect(b_smscenter_choose, SIGNAL(clicked()), this, SLOT(chooseSMSCenter()) );
    setNextEnabled ( currentPage(), false );
    engineNotWorking=i18n("<qt><font color=\"red\"><u><b>IMPORTANT!!</b> Don't even try to select this engine, since at the moment it doesn't run nor compile.</u></font></qt>");
    engineDescLabel->setText(i18n("<qt>Select one of the engines to see details</qt>"));
    btsvcLV->hide();
#ifndef HAVE_KBLUETOOTH
//     wizardLogoPixmap.load( KGlobal::dirs ()->findResource("data", "kmobiletools/bticon.png") );
//     btwizard->setIconSet(QIconSet (wizardLogoPixmap) );
    btStack->raiseWidget(0);
#else
    btStack->raiseWidget(1);
#endif
    resize(minimumSize());
    btStack->setEnabled(false);
    QValueList<KPluginInfo *> engines=EnginesList::instance()->availEngines();
    if(engines.count())
    {
        for(QValueList<KPluginInfo *>::iterator it=engines.begin(); it!=engines.end(); ++it)
            engineSelection->insertItem((*it)->name(), (*it)->service()->library() );
        engineSelected(engineSelection->currentText());
    }
    else
    {
        engineSelection->insertItem(i18n("No engines found. Reinstall KMobileTools"), QString::null );
        setNextEnabled(currentPage(), false);
    }
//     resize( width()+150, minimumSize().height() );
}


newDeviceWizard::~newDeviceWizard()
{
#ifdef KBLUETOOTH
    delete inquiry;
#endif
#ifdef KBLUETOOTH_NEW
    delete  monitor;
#endif
}





/*!
    \fn newDeviceWizard::at_advancedOptions()
 */
void newDeviceWizard::at_advancedOptions()
{
    if( advoptstab->isVisible() )
    {
        advoptstab->hide();
        b_advopts_details->setText(i18n("Details >>"));
        advoptstab->resize( 0,0 );
        resize( page(0)->sizeHint() );

    } else
    {
        advoptstab->show();
        b_advopts_details->setText(i18n("Details <<"));
        advoptstab->resize(advoptstab->sizeHint());
    }
}


/*!
    \fn newDeviceWizard::at_connectionClicked(int index)
 */
void newDeviceWizard::at_connectionClicked(int index)
{
    if( bg_devtype->find( index )->state() == QButton::On) at_selected_connections|= index;
    else at_selected_connections&= ~index;
    kcfg_atdevices->setItems(KMobileTools::KMobiletoolsHelper::getStdDevices(at_selected_connections, kcfg_atdevices->items() ) );
    setNextEnabled ( currentPage(), !kcfg_atdevices->items().isEmpty() );
}



/*!
    \fn newDeviceWizard::selected( const QString & )
 */
void newDeviceWizard::selected( const QString & )
{
    setNextEnabled ( currentPage(), false );
/*    setFinishEnabled (currentPage(), false );*/
    kdDebug() << "Current page index: " << indexOf( currentPage()) << endl;

    if( enginelibname == "libkmobiletools_gammu" ) {
        KMobileTools::DevicesConfig *wconfig = KMobileTools::DevicesConfig::prefs( s_deviceName );
        wconfig->setDevicename( "Gammu" );
        wconfig->setEngine( "libkmobiletools_gammu" );
        deviceConfigDialog *dlg=new deviceConfigDialog( (QWidget*) parent(), name(), wconfig );
        hide();
        QString gammuWarning = i18n("KMobileTools does not support automatic device configuration "
                                    "when using the gammu engine.\n"
                                    "You will have to configure the device yourself!");
        KMessageBox::information( this, gammuWarning, QString::null );
        classicDialog = dlg->exec();
        done( classicDialog );
    }

    switch( indexOf( currentPage() ) ){
        case AT_DEVICE_PAGE:
            if (useBT)
            KMessageBox::information(this, i18n("Your mobile phone now could ask about authorizing your PC at every KMobileTools try to detect services. This is normal, and we higly suggest you to add your PC to the trusted zone for bluetooth. Look your mobile phone manual for this"), QString::null, "warningBluetoothTrusted");
            enginetype=Engine_AT;
            if(!at_selected_connections && (! selBT) ){
                c_usb->setChecked(true); at_selected_connections|=(KMobileTools::KMobiletoolsHelper::USB);
                c_irda->setChecked(true); at_selected_connections|=(KMobileTools::KMobiletoolsHelper::IRDA);
                c_blue->setChecked(true); at_selected_connections|=(KMobileTools::KMobiletoolsHelper::Bluetooth);
                kcfg_atdevices->setItems(KMobileTools::KMobiletoolsHelper::getStdDevices(at_selected_connections) );
            }
            if(manualSVC->isChecked())
            {
                if(! bturl.isNull())
                kcfg_atdevices->insertItem(bturl);
            }
#ifdef HAVE_KBLUETOOTH
	    else
            {
                BtServiceItem *bitem;
                QListViewItemIterator it(btsvcLV);
                while(it.current() )
                {
                    bitem=(BtServiceItem*)it.current();
                    kcfg_atdevices->insertItem(QString("bluetooth://[%1]:%2").arg(
#ifdef KBLUETOOTH
            bitem->bdAddr()
#endif
#ifdef KBLUETOOTH_NEW
            bitem->device->getAddr()
#endif
            ).arg( bitem->text(0)) );
                    ++it;
                }
            }
#endif
            setNextEnabled ( currentPage(), !kcfg_atdevices->items().isEmpty() );
            break;
        case AT_BLUETOOTH_PAGE:
#ifndef HAVE_KBLUETOOTH
            setNextEnabled ( currentPage(), true);

#else
            setNextEnabled ( currentPage(), useBT || ! selBT );

#endif
            break;
        case AT_DEVICESLIST:
            if(! probed) at_Scan_Devices();
            break;
        case AT_DEVICESLOTS:
            at_getDeviceDetails();
            break;
        default:
            setNextEnabled ( currentPage(),(engineSelection->currentItem() != -1) );
            return;
    }
}


/*!
    \fn newDeviceWizard::at_Scan_Devices()
 */
void newDeviceWizard::at_Scan_Devices()
{
    QStringList params;
    params+=kcfg_at_initString->text();
    params+=kcfg_at_initString2->text();
    progress=new KProgressDialog(this, "progress", i18n("Probing devices"), i18n("Probing selected devices. Please wait."), true);
    progress->setAutoClose(true);
    progress->setAllowCancel(false);
    progress->show();
    connect(newDevicesList, SIGNAL(probePercentDone( int )), progress->progressBar(), SLOT(setProgress ( int )) );
    newDevicesList->probeDevices( kcfg_atdevices->items(), enginelibname, params, true, 80000 );
//     progress->exec();
}


/*!
    \fn newDeviceWizard::devicesProbed()
 */
void newDeviceWizard::devicesProbed()
{
//     progress->slotClose();
    delete progress;
    mobilesList->clear();
    if(newDevicesList->count() ) probed=true;
    QPtrListIterator<DeviceInfos> it(*newDevicesList);
    while ( (p_selectedDevice=it.current()) )
    {
        ++it;
        new KListViewItem(mobilesList,
                          p_selectedDevice->foundPath(),
                          p_selectedDevice->rawManufacturer() + "; " +
                                  p_selectedDevice->model() + "; " +
                                  p_selectedDevice->revision() + "; " +
                                  p_selectedDevice->imei()
                         );
    }
    p_selectedDevice=0;
}




/*!
    \fn newDeviceWizard::at_deviceClicked(QListViewItem *item)
 */
void newDeviceWizard::at_deviceClicked(QListViewItem *item)
{
    setNextEnabled ( currentPage(), false );
    if(!item) return;
    p_selectedDevice=newDevicesList->findByPath( item->text(0) );
    if(!p_selectedDevice) return;
    at_devdetails->setText(i18n(
            "<qt>Manufacturer: <b>%1</b><br>\n\
            Model: <b>%2</b><br>\n\
            Software Revision: <b>%3</b><br>\n\
            IMEI: <b>%4</b></qt>")
            .arg(p_selectedDevice->rawManufacturer())
            .arg(p_selectedDevice->model())
            .arg(p_selectedDevice->revision())
            .arg(p_selectedDevice->imei())
                          );
    kcfg_mobileName->setText(p_selectedDevice->rawManufacturer() + " " + p_selectedDevice->model() );
    setNextEnabled ( currentPage(), true );
}


/*!
    \fn newDeviceWizard::at_getDeviceSlots()
 */
void newDeviceWizard::at_getDeviceDetails()
{
    QStringList slotPBSkip;
    slotPBSkip << "MC" << "DC" << "RC" << "ON" << "EN" << "MD" << "LD";
    lv_pbslots->clear(); lv_smsSlots->clear();
    kcfg_at_encoding_2->clear();
    QStringList tempSL;
    smsCenter->setText(p_selectedDevice->smsCenter() );
    QStringList::Iterator it;
    tempSL=p_selectedDevice->pbSlots();
    QCheckListItem *tempItem;
    for(it=tempSL.begin(); it!=tempSL.end(); ++it)
    {
        tempItem=new QCheckListItem(lv_pbslots, *it, QCheckListItem::CheckBox);
        if(slotPBSkip.findIndex( *it ) == -1 )
            (tempItem)->setState(QCheckListItem::On);
        else (tempItem)->setState(QCheckListItem::Off);
        tempItem->setText(1, KMobiletoolsHelper::memorySlotsDescriptions(*it, KMobiletoolsHelper::PhoneBook) );
    }
    tempSL=p_selectedDevice->smsSlots();
    for(it=tempSL.begin(); it!=tempSL.end(); ++it)
    {
        tempItem=new QCheckListItem(lv_smsSlots, *it, QCheckListItem::CheckBox);
        tempItem->setState(QCheckListItem::On);
        tempItem->setText(1, KMobiletoolsHelper::memorySlotsDescriptions(*it, KMobiletoolsHelper::SMS) );
    }
    tempSL=p_selectedDevice->charsets();
    for( it=tempSL.begin(); it!=tempSL.end(); ++it)
        kcfg_at_encoding_2->insertItem( *it );
    kcfg_at_encoding_2->setCurrentItem( "GSM" );
    kcfg_at_encoding_2->setCurrentItem( "8859-1" );
}

void newDeviceWizard::done(int r)
{
    if(! r) { QWizard::done(r); return; }
    if(classicDialog)
    {
        QWizard::done(QDialog::Accepted);
        return;
    }
    if( ! kcfg_mobileName->text().length() )
    {
        KMessageBox::error(this, i18n("Please enter a name for this mobile phone"), i18n("Error") );
        return;
    }
    KMobileTools::DevicesConfig *wconfig=KMobileTools::DevicesConfig::prefs( s_deviceName );
    QStringList sl_devices_new=kcfg_atdevices->items();
    kcfg_atdevices->clear();
    for(QStringList::iterator it=sl_devices_new.begin(); it!=sl_devices_new.end(); ++it)
    {
        if(! ((*it)!=p_selectedDevice->foundPath() && (*it).contains("bluetooth://") ) )
            kcfg_atdevices->insertItem(*it);
    }
    kdDebug() << "Saving engine type:" << engineSelection->currentText() << endl;
    wconfig->setEngine(engineSelection->currentKeyword() );
    wconfig->setDevicename( kcfg_mobileName->text() );
    wconfig->setMobileimei( p_selectedDevice->imei() );
    /// @TODO Perhaps we should use MD5SUM of imei, instead, since it could be unsafe to save a mobile imei to a plane text file..
    wconfig->setAtdevices( kcfg_atdevices->items() );
    wconfig->setAt_usb( c_usb->isChecked() );
    wconfig->setAt_irda( c_irda->isChecked());
    wconfig->setAt_bluetooth( c_blue->isChecked() );
    wconfig->setAt_serial( c_ser->isChecked() );
    wconfig->setAt_availpbslots( p_selectedDevice->pbSlots() );
    wconfig->setAt_availsmsslots( p_selectedDevice->smsSlots() );
    QStringList tmp_slots;
    QListViewItemIterator it(lv_smsSlots, QListViewItemIterator::Checked);
    while(it.current() )
    {
        tmp_slots+=(*it)->text(0);
        ++it;
    }
    wconfig->setAt_smsslots( tmp_slots);
    tmp_slots.clear();
    QListViewItemIterator it2(lv_pbslots, QListViewItemIterator::Checked);
    while(it2.current() )
    {
        tmp_slots+=(*it2)->text(0);
        ++it2;
    }
    wconfig->setAt_pbslots( tmp_slots);
    wconfig->setAt_availencodings( p_selectedDevice->charsets() );
    wconfig->setAt_encoding( kcfg_at_encoding_2->currentText() );
    wconfig->setAt_baudrate( kcfg_at_baudrate->currentItem() );
    wconfig->setSmscenter ( smsCenter->text() );
//     config->writeConfig();
    wconfig->writeConfig();
    QWizard::done(r);
}

void newDeviceWizard::bt_checked( bool on)
{
    btStack->setEnabled(on);
//     btframe->setEnabled(on);
#ifdef HAVE_KBLUETOOTH
    setNextEnabled ( currentPage(), (!on) || (btsvcLV->selectedItem()!=0) );
    if(on) btWizard();
#endif
}


/*!
    \fn newDeviceWizard::btWizard()
 */
void newDeviceWizard::btWizard()
{
#ifdef HAVE_KBLUETOOTH
    btDevicesLV->clear();
#ifdef KBLUETOOTH
    btSocket=new KBluetooth::HciSocket(inquiry, "");
    btSocket->open();
    inquiry=new KBluetooth::Inquiry(btSocket);
    connect(inquiry, SIGNAL(finnished()), this, SLOT(btScanFinished()));
    connect(inquiry, SIGNAL(error(int, QString )), this, SLOT(btScanFinished()));
    connect(inquiry, SIGNAL(neighbourFound (const KBluetooth::DeviceAddress&, int)), this, SLOT(btScanItemFound(const KBluetooth::DeviceAddress&, int)));
#else
    if(!monitor) monitor=new BlueMonitor(btDevicesLV);
#endif
    btStatusLabel->setText( i18n("Searching for bluetooth devices.") );
    btsvcLV->clear();
    bturl=QString::null;
    btStartScan();
#else
    KRun::runCommand("kbluetoothpairingwizard");
#endif
}

void newDeviceWizard::btStartScan()
{
#ifdef KBLUETOOTH
    if(!inquiry) return;
//     inquiry->reset();
    inquiry->inquiry();
#endif
#ifdef KBLUETOOTH_NEW
monitor->restartPeriodicDiscovery();
#endif
}

void newDeviceWizard::btStopScan()
{
#ifdef KBLUETOOTH
//     while( inquiry->isComplete() ){
//         usleep(500);
//     }
    if (! inquiry) return;
    kdDebug() << "Closing bluetooth socket\n";
    btSocket->close();
    delete btSocket;
    btSocket=NULL;
    kdDebug() << "Closed. Deleting inquiry object\n";
    delete inquiry;
    kdDebug() << "Inquiry deleted\n";
    inquiry=NULL;

#endif
#ifdef KBLUETOOTH_NEW
    monitor->stopDisco();
#endif
#ifdef HAVE_KBLUETOOTH
    btStatusLabel->setText( i18n("Search stopped. Please <a href=\"#\">click here</a> to search bluetooth devices again.") );
    disconnect(btStatusLabel, SIGNAL(linkClicked ( const QString &)), btStatusLabel, SLOT(openLink( const QString &)));
#endif
}

void newDeviceWizard::btScanFinished()
{
#ifdef HAVE_KBLUETOOTH
//     delete inquiry;
//     delete progress;
    if(btenable->isChecked () && ! btDevicesLV->selectedItem() )
    QTimer::singleShot(1500, this, SLOT(btStartScan()));
    else
        btStopScan();
#endif
}

void newDeviceWizard::btScanItemFound(const KBluetooth::DeviceAddress &bdaddr, int /*deviceClass*/)
{
#ifdef KBLUETOOTH
    QPtrList<QListViewItem> lst;
    QListViewItemIterator it( btDevicesLV );
    BtDeviceItem *item;
    while ( it.current() ) {
        item=(BtDeviceItem*)(it.current());
        if ( item->bdAddr()==bdaddr ) return;
        ++it;
    }
    kdDebug() << "Found new item: " << bdaddr << endl;
    new BtDeviceItem(btDevicesLV, bdaddr);
#endif
}

void newDeviceWizard::btDeviceClicked(QListViewItem* item)
{
    kdDebug() << k_funcinfo << endl;
#ifdef HAVE_KBLUETOOTH
    if(!item) return;
    btStopScan();
    BtDeviceItem* bitem=(BtDeviceItem*)(item);
#ifdef KBLUETOOTH
    bitem->device()->setTarget(bitem->bdAddr());
    kdDebug() << "Services updated\n";
#endif
    btsvcLV->clear();
    bturl=QString::null;
    setNextEnabled(currentPage(), false);
    if(! bitem->device()->services().size()) return;
    setNextEnabled(currentPage(), !manualSVC->isChecked() );

#ifdef KBLUETOOTH
    for(uint i=0; i<bitem->device()->services().size(); i++)
        new BtServiceItem(btsvcLV, &bitem->device()->services().at(i), bitem->bdAddr() );
#endif
#ifdef KBLUETOOTH_NEW
    kdDebug() << "bluetooth_new services count: " << bitem->device()->hservices.size() << endl;
    for(uint i=0; i<bitem->device()->hservices.size(); i++)
        (new BtServiceItem(btsvcLV, *(bitem->device()->hservices.at(i)) ))->device=bitem->device();
#endif
    setNextEnabled(currentPage(), true);
#endif
}

void newDeviceWizard::btServiceClicked(QListViewItem* item)
{
#ifdef HAVE_KBLUETOOTH
    bturl=QString::null;
    if(!item) return;
    BtServiceItem* bitem=(BtServiceItem*)(item);
    setNextEnabled ( currentPage(), (!btenable->isOn()) || (btsvcLV->selectedItem()!=0) );
    bturl=QString("bluetooth://[%1]:%2").arg(
#ifdef KBLUETOOTH
            bitem->bdAddr()
#endif
#ifdef KBLUETOOTH_NEW
            bitem->device->getAddr()
#endif
            ).arg( bitem->text(0) );
    kdDebug() << "Selected bluetooth device: \"" << bturl << "\"" << endl;
#endif
}



/*!
    \fn newDeviceWizard::permissionWizard()
 */
void newDeviceWizard::permissionWizard()
{
    KRun::runCommand("kmtsetup");
}
#include "newdevicewizard.moc"



/*!
    \fn newDeviceWizard::engineSelected(int)
 */
void newDeviceWizard::engineSelected(const QString &enginename)
{
    KPluginInfo *engInfo=EnginesList::instance()->engineInfo(enginename, false);
    if(!engInfo) return;
    engineDescLabel->setText(engInfo->property("X-KMobileTools-LongDesc").asString().replace('\n',"<br>") );
    setNextEnabled ( currentPage(), true );
    enginelibname=engInfo->service()->library();
/*
    switch( i ){
        case 0:
            engineDescLabel->setText(i18n("<qt>AT Engine<br><a href=\"http://www.kmobiletools.org\">KMobileTools</a> default engine, developed interally by the KMobileTools team.<br>Good choice with almost all mobile phones, but on some models it lacks advanced features. Best choice with Motorola Phones, works good also with Sony Ericsson and Siemens.</qt>"));
            enginelibname="libkmobiletools_at"; break;
#ifdef WITH_GAMMU
        case 1:
            setNextEnabled ( currentPage(), false );
            engineDescLabel->setText(i18n("<qt>Gammu Engine.<br>Uses <a href=\"http://www.gammu.org\">Gammu</a> to communicate with the mobile phone.<br>It's the best selection above all for Nokia mobile phones.<br></qt>") + engineNotWorking);
            enginelibname="libkmobiletools_gammu";
            return;
#endif
        default:
            setNextEnabled ( currentPage(), false );
            return;
    }
    setNextEnabled ( currentPage(), true );*/
}


/*!
    \fn newDeviceWizard::checkAdvParams()
 */
void newDeviceWizard::checkAdvParams()
{
    int ok=0;
    QListViewItemIterator it( lv_smsSlots, QListViewItemIterator::Checked );
    while ( it.current() ) {
        ok++;
        ++it;
    }
    if(!ok && lv_smsSlots->childCount() ) { setNextEnabled ( currentPage(), false ); return; }
    it=QListViewItemIterator(lv_pbslots, QListViewItemIterator::Checked );
    ok=0;
    while ( it.current() ) {
        ok++;
        ++it;
    }
    if(!ok && lv_pbslots->childCount() ) { setNextEnabled ( currentPage(), false ); return; }

    if(! smsCenter->text().length() ) { setNextEnabled ( currentPage(), false ); return; }
    if(! kcfg_at_encoding_2->currentText().length() ) { setNextEnabled ( currentPage(), false ); return; }

    setNextEnabled ( currentPage(), true );
}


/*!
    \fn newDeviceWizard::chooseSMSCenter()
 */
void newDeviceWizard::chooseSMSCenter()
{
    PickSMSCenter *dlg=new PickSMSCenter(this);
    dlg->exec();
    if(dlg->smsCenter() != QString::null ) smsCenter->setText(dlg->smsCenter() );
}



/*!
    \fn newDeviceWizard::skipWizard()
 */
void newDeviceWizard::skipWizard()
{
    KMobileTools::DevicesConfig *wconfig=KMobileTools::DevicesConfig::prefs( s_deviceName );
    deviceConfigDialog *dlg=new deviceConfigDialog( (QWidget*) parent(), name(), wconfig );
    hide();
    classicDialog=dlg->exec();
    done(classicDialog);
}


/*!
    \fn newDeviceWizard::slotManualServices(bool)
 */
void newDeviceWizard::slotManualServices(bool set)
{
    if(set) btsvcLV->show();
    else btsvcLV->hide();
    btsvcLV->setEnabled(set);
    setNextEnabled ( currentPage(), useBT || ! selBT || ( useBT && !set) );
    resize(minimumSize());
}
