/***************************************************************************
   Copyright (C) 2007
   by Marco Gulino <marco@kmobiletools.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the
   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
 ***************************************************************************/
#ifndef NEWDEVICEWIZARD_H
#define NEWDEVICEWIZARD_H

#include <ui_newdevicewizard.h>
#include <qptrlist.h>
#include "config.h"
#include "bluetoothitems.h"

/**
	@author Marco Gulino <marco@kmobiletools.org>
*/
class KProgressDialog;
class engineLoader;
class DeviceInfos;
class DevicesInfoList;
class BlueMonitor;

class newDeviceWizard : public ui_newdevicewizard
{
Q_OBJECT
public:
    newDeviceWizard(QWidget *parent = 0, const char *name = 0);

    ~newDeviceWizard();
    enum EngineType { Engine_AT=0x1, Engine_Gammu=0x2 };

    protected slots:
        void at_advancedOptions();
        void at_connectionClicked(int index);
        void at_deviceClicked(QListViewItem *item);
        void bt_checked(bool);
    private:
        int at_selected_connections;
        DevicesInfoList *newDevicesList;
        DeviceInfos *p_selectedDevice;
        QString s_deviceName;
        void done(int r);
        int enginetype;
        KProgressDialog *progress;
        bool probed;
        QString enginelibname;
        QString engineNotWorking;
        QString bturl;
        bool classicDialog;
#ifdef KBLUETOOTH
        KBluetooth::Inquiry *inquiry;
        KBluetooth::HciSocket *btSocket;
#endif
#ifdef KBLUETOOTH_NEW
        BlueMonitor *monitor;
#endif


public slots:
    void selected( const QString & );
    void at_Scan_Devices();
    void at_getDeviceDetails();
    void btWizard();
    void btStartScan();
    void btStopScan();
    void btScanFinished();
    void btDeviceClicked(QListViewItem *);
    void btServiceClicked(QListViewItem *);
    void btScanItemFound(const KBluetooth::DeviceAddress &bdaddr, int deviceClass);
    void permissionWizard();
    void devicesProbed();
    void engineSelected(const QString &);
    void checkAdvParams();
    void chooseSMSCenter();
    void skipWizard();
    void slotManualServices(bool);
};

#endif
