/***************************************************************************
 *   Copyright (C) 2006 by Marco Gulino   *
 *   marco@kmobiletools.org   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#ifndef _KSERIALDEVICEEMULATORWIDGET_H_
#define _KSERIALDEVICEEMULATORWIDGET_H_

#include "kserialdeviceemulatorwidgetbase.h"
#include "commandslist.h"
#include <klistview.h>
class CommandListViewItem : public KListViewItem
{
    public:
        CommandListViewItem(KListView *parent, const Command &command);
        Command command() { return cmd; }
    private:
        Command cmd;
};

class KSerialDeviceEmulatorWidget : public KSerialDeviceEmulatorWidgetBase
{
    Q_OBJECT

public:
    KSerialDeviceEmulatorWidget(QWidget* parent = 0, const char* name = 0, WFlags fl = 0 );
    ~KSerialDeviceEmulatorWidget();
    /*$PUBLIC_FUNCTIONS$*/

public slots:
    /*$PUBLIC_SLOTS$*/
    void addToLog(const QString &text, const QString &color);
    void loadClicked();
    void updateCommandListView();
    void removeCmd();
    void commandClicked ( QListViewItem * item );
    void removeAllCmds();
    void resetEvent();
    void slotSendEvent();
    void eventSelected(int);
    void clearLog();
protected:
    /*$PROTECTED_FUNCTIONS$*/

protected slots:
    /*$PROTECTED_SLOTS$*/
    void slotSendEvent(const QString &);
    signals:
        void loadFile(const QString &);
    void sendEvent(const QString &);

};

#endif

