/***************************************************************************
 *
 * knetworkmanager-vpn.h - A NetworkManager frontend for KDE 
 *
 * Copyright (C) 2006 Novell, Inc.
 *
 * Author: Timo Hoenig <thoenig@suse.de>, <thoenig@nouse.net>
 *         Helmut Schaa <hschaa@suse.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

#ifndef KNETWORKMANAGER_VPN_H
#define KNETWORKMANAGER_VPN_H

#include <NetworkManager/NetworkManager.h>
#include <NetworkManager/NetworkManagerVPN.h>

#include <qobject.h>
#include <qguardedptr.h>

#include "knetworkmanager.h"
#include "manageconnections.h"
#include "editconnection.h"
#include "authentication.h"
#include "knetworkmanager-vpnplugin.h"

class KNetworkManager;
class ManageConnectionsDialog;
class VPN;
class VPNConnection;
class VPNService;
class KProcess;
class KConfigGroup;
 
class VPNConnection : public QObject
{
	Q_OBJECT

	public:
	  VPNConnection( const QString &cfgGrp, VPN* parent, const char * name = 0);
	  VPNConnection( VPN*, const char* = 0);
	  ~VPNConnection ();
	  VPNConnection  (const VPNConnection &);

	  void setServiceName     (const QString &);
	  void serService         (const QString &);
	  void setName            (const QString &);
	  void setUser            (const QString &);
	  void addRoute           (const QString &);
	  void setRoutes          (const QStringList &);
	  void addData            (const QString &);
	  void setData            (const QStringList &);
	  void addPasswords       (const QStringList &, bool storePasswordsPermanent = false, bool storePasswordsSession = false );
	  void setActivationStage (NMVPNActStage);
	  void setAuthHelper      (const QString &);
	  void restore            (const KConfigGroup &);
	  bool save               ();
	  void remove             ();
	  void setVPNConnectionFailure (QString&, QString&);
	  void setConfigGroup     (const QString&);

	  QString       getServiceName     (void) const;
	  QString       getService         (void) const;
	  QString       getName            (void) const;
	  QString       getUser            (void) const;
	  QStringList   getRoutes          (void) const;
	  QStringList   getData            (void) const;
	  QStringList   getPasswords       (void) const;
	  NMVPNActStage getActivationStage (void) const;
	  QString       getAuthHelper      (void) const;
	  VPNService*   getVPNService      (void) const;
	  bool          isValid            (void);
	  bool          hasPasswordsStored (void);
	  bool          isReadonly         (void);
	  void          restorePasswords   (void);
	  bool          isConfirmedByNM    (void);
	  void          setConfirmedByNM   (bool);

	public slots:
	  void slotCredentialsLoaded(QString, QMap<QString, QString>, bool);
	  void receiveAuthenticationData (KProcess*, char*, int);
	  void authHelperExited          (KProcess*);
	  void authHelperExited          (bool, QStringList &);
	  void authHelperExited          (bool, QStringList &, bool storePasswordsPermanent, bool storePasswordsSession );


	signals:
	  void activationStateChanged (void);
	  void connectionFailure(QString&, QString&);
	  void passwordsRestored(bool, QStringList&, bool, bool);

	private:
	  QString       _name;
	  QString       _user;
	  QStringList   _routes;
	  QStringList   _data;
	  QStringList   _passwords;
	  NMVPNActStage _activationStage;
	  QString       _authHelper;
	  bool          _dirty;
	  bool          _deleted;
	  KConfigGroup* _cfgGrp;
	  VPN*          _vpn;
	  VPNService*   _vpnService;
	  bool          _storePasswordsPermanent;
	  bool          _storePasswordsSession;
	  bool          _readonly;
	  bool          _confirmedByNM;
};

class VPNService : public QObject
{
	Q_OBJECT

	public:
	  VPNService(const QString& serviceName, const QString& service, VPN* parent, const char* name = 0);
	  ~VPNService();

	  QString getDisplayName() const;
	  QString getName() const;
	  QString getService() const;
	  bool hasInternalAuthentication();
	  QString getAuthHelper();
	  VPNPlugin* getVPNPlugin();
	  QString getIcon();

	private:
	  QString readAuthHelper();

	  bool    _useInternalAuthentication;
	  QString _extAuthDialog;
	  QString _name;
	  QString _service;
	  VPN*    _vpn;
	  QGuardedPtr<VPNPlugin> _vpnPlugin;
};


typedef QValueList<VPNConnection*> VPNList;
typedef QValueList<VPNService*> VPNServiceList;

class VPN : public QObject
{
	Q_OBJECT

	public slots:
	  void receiveKeyringData        (KProcess*, char*, int);
	  void activateVPNConnection     (VPNConnection*);
	  void disconnectVPNConnection   (void);
	  void updateVPNConnections      (KProcess*);
	  void updateVPNConnections      ();
	  void vpnActivationStateChanged ();
	  void startGnomeVPNConfig();

	public:
	  VPN( KNetworkManager * parent = 0, const char * name = 0);
	  ~VPN ();

	  VPNConnection* newVPNConnection ();
	  bool           appendVPNConnection (VPNConnection* conn);
	  VPNConnection* getVPNConnection (const QString &);
	  void           deleteVPNConnection (const QString &);
	  bool           importVPNConnection(const QString&);
	  VPNList*       getVPNList       (void);
	  bool           isActive         (void);
	  bool           isAvailable      (void);
	  QStringList    getVPNServices ();
	  VPNService*    getVPNService(const QString &);
	  QStringList    listGConfConnections();
	  KNetworkManager* getCtx();
	  void           push (KNetworkManager*);
	  bool           hasGnomeVPNConfig();

	signals:
	  void vpnConnectionStateChanged(bool);
	  void vpnConnectionsUpdated();

	private:
	  void initKeyring        (void);
	  bool getServices        (void);
	  void getGConfConnection (const QString &);
	  void getConnections     (void);
	  void addConnection      (const QString &);
	  QString getAuthHelper   (const QString &);

	  KNetworkManager* _ctx;
	  VPNServiceList* _vpnServiceList;
	  VPNList*        _vpnList;
	  QString         _confPath;
	  bool            _available;
	  QString         _gnomeVPNApplet;
};

#endif /* KNETWORKMANAGER_VPN_H */
