/***************************************************************************
 *
 * knetworkmanager-vpn_dbus.h - A NetworkManager frontend for KDE
 *
 * Copyright (C) 2006 Novell, Inc.
 *
 * Author: Timo Hoenig <thoenig@suse.de>, <thoenig@nouse.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **************************************************************************/

#ifndef KNETWORKMANAGER_VPN_DBUS_H
#define KNETWORKMANAGER_VPN_DBUS_H

#include "knetworkmanager.h"
#include "knetworkmanager-dbus.h"
#include "knetworkmanager-vpn.h"

//class VPNConnection;

class VPNDBus
{
	public:

	  static void updateVPNActivationStage    (const char*, NMVPNActStage);
	  static void updateVPNConnectionCallback (DBusPendingCall*, void*);
	  static void updateVPNConnection         (const char*);
	  static void updateVPNConnection         (VPNConnection*);
	  static void activateVPNConnection       (VPNConnection*);
	  static void disconnectVPNConnection     (void);
	  static void showVPNConnectionFailure    (const char* member, const char* vpn_name, const char* err_msg);
	  static void push (KNetworkManager*);

	private:

	  static KNetworkManager* _ctx;
};

#endif /* KNETWORKMANAGER_VPN_DBUS_H */
