/***************************************************************************
 *   Copyright (C) 2005 by SUZUKI Tasuku                                   *
 *   tasuku@linux-life.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "kkdsubscribetemplatedialog.h"
#include "kkdcategorybutton.h"
#include "kkdsender.h"

#include <kglobal.h>
#include <klocale.h>
#include <kdebug.h>
#include <qgrid.h>
#include <qvbox.h>
#include <qlabel.h>
#include <qimage.h>
#include <kdebug.h>
#include <qfileinfo.h>
#include <kmessagebox.h>
#include <kconfig.h>
#include <qbitmap.h>
#include <ktempfile.h>

#include <stdio.h>
#include <pwd.h>
#include <unistd.h>

#include <sys/utsname.h>

using namespace KKDSubscribeTemplate;

KKDSubscribeTemplateDialog::KKDSubscribeTemplateDialog( const QString& filename, QWidget* parent, const char* name )
	: KDialogBase( parent, name, true, i18n( "Send Template" ), Ok|Cancel ), m_filename( filename )
{
	setupWidgets();
	QFileInfo info( filename );
	m_txtTitle->setText( info.baseName() );
	m_txtNewCategory->setText( i18n( "New Category" ) );
	suggestChanged();

	// find out the default profile
	KConfig emailConf( QString::fromLatin1("emaildefaults") );
	emailConf.setGroup( QString::fromLatin1("Defaults") );
	QString profile = QString::fromLatin1("PROFILE_");
	profile += emailConf.readEntry( QString::fromLatin1("Profile"),
									QString::fromLatin1("Default") );

	emailConf.setGroup( profile );
	QString fromaddr = emailConf.readEntry( QString::fromLatin1("EmailAddress") );
	if( fromaddr.isEmpty() )
	{
		struct passwd *p;
		p = getpwuid( getuid() );
		fromaddr = QString::fromLatin1( p->pw_name );
	}
	m_txtMail->setText( fromaddr );

	m_txtName->setText( emailConf.readEntry( QString::fromLatin1("FullName") ) );

	resize( configDialogSize( "KKDSendTemplateDialog" ) );
}

KKDSubscribeTemplateDialog::~KKDSubscribeTemplateDialog()
{
	saveDialogSize( "KKDSendTemplateDialog" );
}

void KKDSubscribeTemplateDialog::setupWidgets()
{
	QGrid* grid = new QGrid( 2, this );
	QLabel* lbl = new QLabel( i18n( "&Category:" ), grid );
	m_btnCategory = new KKDCategoryButton( grid );
	lbl->setBuddy( m_btnCategory );

	new QWidget( grid );
	QHBox* hbox = new QHBox( grid );
	m_chkSuggest = new QCheckBox( i18n( "&Suggest" ), hbox );
	connect( m_chkSuggest, SIGNAL( clicked() ), this, SLOT( suggestChanged() ) );
	m_txtNewCategory = new KLineEdit( hbox );

	lbl = new QLabel( i18n( "&Title:" ), grid );
	m_txtTitle = new KLineEdit( grid );
	lbl->setBuddy( m_txtTitle );

	lbl = new QLabel( i18n( "Preview" ), grid );
	m_label = new QLabel( grid );

	lbl = new QLabel( i18n( "C&omment" ), grid );
	m_txtComment = new KTextEdit( grid );
	lbl->setBuddy( m_txtComment );

	lbl = new QLabel( i18n( "&Name" ), grid );
	m_txtName = new KLineEdit( grid );
	lbl->setBuddy( m_txtName );

	lbl = new QLabel( i18n( "&E-Mail" ), grid );
	m_txtMail = new KLineEdit( grid );
	lbl->setBuddy( m_txtMail );

	lbl = new QLabel( i18n( "A&greement" ), grid );
	QVBox* vbox = new QVBox( grid );
	KTextEdit* txt = new KTextEdit( vbox );
	txt->setText( i18n( "a\nb\nc\nd\ne\nf\ng" ) );
	txt->setReadOnly( true );
	m_chkAccept = new QCheckBox( i18n( "&Accept" ), vbox );
	lbl->setBuddy( m_chkAccept );
	setMainWidget( grid );
}

void KKDSubscribeTemplateDialog::slotOk()
{
/*	scaleChange( m_preview, m_preview.size() / 5 ).save( "/home/tasuku/tmp.png", "PNG" );
	return;*/
	if( isError() ) return;
	send();
// 	if( send() ) KDialogBase::slotOk();
}

void KKDSubscribeTemplateDialog::addPixmap( const QPixmap& pix )
{
	bool blLandscape = ( pix.width() > pix.height() );
	int i = ( blLandscape ? pix.width() : pix.height() );
	int di = i - ( blLandscape ? pix.height() : pix.width() );
	di /= 2;
	QPixmap pixCentering( scaleChange( pix, i ) );
	QBitmap mask( i, i, true );
	if( blLandscape )
	{
		bitBlt( &pixCentering, 0, di, &pix );
		QBitmap m( i, i - 2 * di );
		m.fill( Qt::color1 );
		bitBlt( &mask, 0, di, &m );
	}
	else
	{
		bitBlt( &pixCentering, di, 0, &pix );
		QBitmap m( i - 2 * di, i );
		m.fill( Qt::color1 );
		bitBlt( &mask, di, 0, &m );
	}
	pixCentering.setMask( mask );

	if( m_preview.isNull() )
	{
		m_preview = pixCentering;
		m_preview.setMask( *pixCentering.mask() );
	}
	else
	{
		int w = m_preview.width();
		m_preview.resize( w + pixCentering.width(), m_preview.height() );
		mask.resize( m_preview.size() );
		bitBlt( &m_preview, w, 0, &pixCentering );
		bitBlt( &mask, 0, 0, m_preview.mask() );
		bitBlt( &mask, w, 0, pixCentering.mask() );
		m_preview.setMask( mask );
	}
	m_label->setPixmap( scaleChange( m_preview, m_preview.size() / 5 ) );
}

QPixmap KKDSubscribeTemplateDialog::scaleChange( const QPixmap& pix, const QSize& s )
{
	QImage img = pix.convertToImage();
	QPixmap rtn;
	rtn.convertFromImage( img.smoothScale( s ) );
	return rtn;
}

bool KKDSubscribeTemplateDialog::isError()
{
	if( m_btnCategory->text() == "" )
	{
		KMessageBox::error( this, i18n( "Category is not selected" ) );
		m_btnCategory->setFocus();
		return true;
	}

	if( m_txtNewCategory->isEnabled() && m_txtNewCategory->text() == "" )
	{
		KMessageBox::error( this, i18n( "New category is empty" ) );
		m_txtNewCategory->setFocus();
		return true;
	}

	if( m_txtTitle->text() == "" )
	{
		KMessageBox::error( this, i18n( "Title is empty" ) );
		m_txtTitle->setFocus();
		return true;
	}

	if( m_txtComment->text() == "" )
	{
		KMessageBox::error( this, i18n( "Comment is empty" ) );
		m_txtComment->setFocus();
		return true;
	}

	if( m_txtName->text() == "" )
	{
		KMessageBox::error( this, i18n( "Name is empty" ) );
		m_txtName->setFocus();
		return true;
	}

	if( m_txtMail->text() == "" )
	{
		KMessageBox::error( this, i18n( "Mail is empty" ) );
		m_txtMail->setFocus();
		return true;
	}

	if( !m_chkAccept->isChecked() )
	{
		KMessageBox::error( this, i18n( "Accept below agreement" ) );
		m_chkAccept->setFocus();
		return true;
	}
	return false;
}

bool KKDSubscribeTemplateDialog::send()
{
	KTempFile tmpFile;
	tmpFile.setAutoDelete( true );
	scaleChange( m_preview, m_preview.size() / 5 ).save( tmpFile.name(), "PNG" );

	KKDSender sender;
	sender.addText( "mode", "upload" );
	sender.addText( "lang", KGlobal::locale()->language() );
	sender.addText( "category", m_btnCategory->category() );
	if( m_chkSuggest->isChecked() ) sender.addText( "newcategory", m_txtNewCategory->text() );
	sender.addText( "title", m_txtTitle->text() );
	sender.addText( "comment", m_txtComment->text() );
	sender.addText( "author", m_txtName->text() );
	sender.addText( "mail", m_txtMail->text() );
	sender.addFile( "preview", tmpFile.name() );
	sender.addFile( "file", m_filename );
	sender.send();
	return true;
}

void KKDSubscribeTemplateDialog::suggestChanged()
{
	m_txtNewCategory->setEnabled( m_chkSuggest->isChecked() );
}
