/***************************************************************************
 *   Copyright (C) 2005 by SUZUKI Tasuku                                   *
 *   tasuku@linux-life.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef _KKDVIEW_H_
#define _KKDVIEW_H_

#include <qscrollview.h>
#include <qptrlist.h>

#include "kkditembase.h"

namespace KKDesigner
{
	class KKDCanvas;
	class KKDDoc;

	typedef QPtrList<KKDCanvas> KKDCanvasList;

	class KKDView : public QScrollView
	{
		Q_OBJECT
	public:
		KKDView( KKDItemBase::DrawMode m, KKDDoc* doc, QWidget* parent = 0, const char* name = 0 );
		virtual ~KKDView();
		KKDCanvasList& canvas(){ return m_canvas; }

	signals:
		void zoomupEnabledChanged( bool );
		void zoomdownEnabledChanged( bool );

	public slots:
		void zoomIn();
		void zoomOut();
		void insertText();
		void insertImage();
		void insertAddressee();
		void insertAddress();
		void insertZipcode();
		void setContactData( const KKAddressBook::KKAContactData* d );
		void setSender( const KKAddressBook::KKAContactData* d );
		void documentChanged();

	protected:
		void wheelEvent( QWheelEvent* e );

	private slots:
		void setLayout();

	private:
		double zoom();
		void setZoom( int z );
		int m_zoom;
		QWidget* wgtMain;
		KKDCanvasList m_canvas;
		KKDDoc* m_doc;
		KKDItemBase::DrawMode m_mode;
		const KKAddressBook::KKAContactData* m_data;
		const KKAddressBook::KKAContactData* m_sender;
	};
}
#endif /* _KKDVIEW_H_ */
