#!/usr/bin/ruby

# SUBDIRS = 01_empty 02_12
# kktemplatesdir = $(kde_datadir)/kreetingkard/templates/10_newyears/
# kktemplates_DATA = metadata.xml

BASEDIR = '$(kde_datadir)/kreetingkard/templates/'

def createMakefile_am( dir )
	return false if dir != "" && !File.exists?( dir + "metadata.xml" )
	subdirs = []
	data = []
	data.push( "metadata.xml" ) if File.exists?( dir + "metadata.xml" )
	Dir.glob( "#{dir}*" ) do |d|
		case File.ftype( d )
		when "file"
			data.push( d.sub( "#{dir}", "" ) ) if [ ".kk", ".png" ].include?( File.extname( d ) )
		when "directory"
			if createMakefile_am( d + "/" )
				subdirs.push( d.sub( "#{dir}", "" ) )
			end
		end
	end
	
	str = ""
	if !subdirs.empty?()
		str += "SUBDIRS = #{subdirs.join( " " )}\n"
	end
	if !data.empty?()
		str += "kktemplatesdir = $(kde_datadir)/kreetingkard/templates/#{dir.sub( /\/$/, "" )}\n"
		str += "kktemplates_DATA = #{data.join( " " )}\n"
	end
	File.open( "#{dir}Makefile.am", "w" ) do |f|
		f.write str
	end
	return true
end

createMakefile_am( "" )
