/***************************************************************************
                          krenamedcop.h  -  description
                             -------------------
    begin                : Sat Dec 27 23:54:28 CET 2003
    copyright            : (C) 2003 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KRENAMEDCOP_H
#define KRENAMEDCOP_H

#include <dcopobject.h>
#include <qstringlist.h>
#include <kurl.h>

class KRenameDCOP : virtual public DCOPObject
{
    K_DCOP

    public:
    k_dcop:
        virtual void addFileOrDir( const QString & name ) = 0;
        virtual void addDir( const QString & name, const QString & filter, bool recursive, bool hidden, bool dirnames ) = 0;
        virtual void updatePre() = 0;

        virtual void setFileNameTemplate( const QString & t ) = 0;
        virtual const QString fileNameTemplate() const = 0;

        virtual void setExtensionTemplate( const QString & t ) = 0;
        virtual const QString extensionTemplate() const = 0;

        virtual void setUseExtension( bool b ) = 0;
        virtual bool useExtension() const = 0;

        virtual void setCounterStart( int index ) = 0;
        virtual int counterStart() const = 0;
        
        virtual void start() = 0;
        
        virtual QStringList tokens() const = 0;
        
        virtual QString parseString( const QString & token, const QString & string ) = 0;
};

#endif /* KRENAMEDCOP_H */

