/***************************************************************************
                          pluginloader.h  -  description
                             -------------------
    begin                : Sun Dec 30 2001
    copyright            : (C) 2001 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef PLUGINLOADER_H
#define PLUGINLOADER_H

// Own includes
#include "batchrenamer.h"
#include "plugin.h"

#include <qmap.h>
#include <qptrlist.h>

class QCheckBox;
class QVBoxLayout;
class QString;
class QWidget;

#define NUM_INTERNAL_PLUGINS 8

enum pluginType {
    TYPE_BRACKET = 2,       // Plugin argument is in brackets like [artist] or [1-2]
    TYPE_TOKEN = 4,         // Plugin has its own reserved token like ,& or /
    TYPE_FINAL_FILE = 8,    // Plugin does something with the final file
                            // i.e. that is not changing its name but its permission or similar!
    TYPE_FINAL_FILENAME = 16  // Plugin changes the final filename before renaming
};

class PluginLoader {
    public:
        // For RedHat :)
        struct PluginLibrary {
            Plugin *plugin;
            bool usePlugin;

            /* access this member only
             * from within KRenameImpl
             * when the GUI is already constructed!
             */
            QCheckBox* check;
        };

        static PluginLoader* instance();

        void loadPlugins( bool fileplugins );
        QPtrList<PluginLoader::PluginLibrary> libs;
        
        Plugin* findPlugin( const QString & token );
        
        inline bool filePluginsLoaded() const;

        void clearCache();
        
    private:
        PluginLoader();
        ~PluginLoader();

        void addPlugin( Plugin* plugin );
        void loadFilePlugins();
        
    private:

        Plugin* m_internal_plugins[NUM_INTERNAL_PLUGINS];
        static PluginLoader* m_plugin;

        QMap<QString,Plugin*> m_bracket_map;
        QMap<QString,Plugin*> m_bracket_cache;
        
        bool m_loaded;
        bool m_file;
};

bool PluginLoader::filePluginsLoaded() const
{ 
    return m_file;
}

#endif
