/***************************************************************************
 *   Copyright (C) 2006 by the KSmoothDock team   *
 *   dangvd@yahoo.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef BUTTONISEDSTATE_H
#define BUTTONISEDSTATE_H

#include <qobject.h>
#include "dockstate.h"

#include <kpixmap.h>

/**
	@author the KSmoothDock team <dangvd@yahoo.com>
*/
class ButtonisedState : public QObject, public DockState
{
    Q_OBJECT
public:
    ButtonisedState(KSmoothDock* dock);

    /// Paint event handler    
    virtual void paintEvent(QPaintEvent* e);

    /// Mouse pressed event handler
    virtual void mousePressEvent(QMouseEvent* e);
    
    /// Mouse moved event handler
    virtual void mouseMoveEvent(QMouseEvent* e);

    /// Enter event handler
    virtual void enterEvent(QEvent* e);

    /// Leave event handler
    virtual void leaveEvent(QEvent* e);

    /// Update the layout
    virtual void updateLayout(bool reset = true);

    /// Update background
    virtual void updateBackground();

    /// Update a specific item
    virtual void updateItem(int itemIndex);

private: // functions

    /// Update background image
    void updateBackgroundImage();
private:
    int m_w; // dock's width
    int m_h; // dock' height

    std::auto_ptr<KPixmap> m_background; // background image
    std::auto_ptr<QPixmap> m_buffer; // off-screen buffer image
};

#endif
