/***************************************************************************
 *   Copyright (C) 2006 by the KSmoothDock team   *
 *   dangvd@yahoo.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "clock.h"

#include <iostream>

#include <qapplication.h>
#include <qcursor.h>
#include <qdatetime.h>
#include <qpainter.h>
#include <qtimer.h>

#include <klocale.h>

#include "constants.h"
#include "ksmoothdock.h"

Clock::Clock() {}

/**
 * Constructor
 */

Clock::Clock(KSmoothDock* parent, int itemId, QString desc, int desktop, int minSize, int maxSize, double whRatio, Qt::Orientation orientation)
 : IconlessDockItem(parent, itemId, desc, desktop, minSize, maxSize, whRatio, orientation) {
    QTimer* timer = new QTimer(this);
    connect(timer, SIGNAL(timeout()), this, SLOT(updateTime()));
    timer->start(1000); // 1 second timer
    m_calendar = NULL;
    
    QString clock_format;
    if (m_use24HourClock) {
        clock_format=QString("hh:mm");
    } else { // 12 Hour Clock
        clock_format=QString("h:mm ap");
    }
    m_text = QTime::currentTime().toString(clock_format);
}

/**
 * Draw itself into the offscreen buffer
 */

void Clock::draw(QPixmap& buffer, int x, int y, int size) {
    QPainter p(&buffer);

    p.setPen(m_fontColor);
    p.setFont(m_font);

    int dx = 0;
    int dy = 0;
    int w = 0;
    int h = 0;

    w = getWidth(m_maxSize);
    h = getHeight(m_maxSize);
    dx = (w - getWidth(size)) / 2;
    dy = (h - getHeight(size)) / 2;

    QRect r(x - dx, y - dy, w, h);
    p.drawText(r, AlignCenter, m_text);
}

/**
 * Mouse pressed event handler
 */

void Clock::mousePressEvent(QMouseEvent* e) {
    if (e->button() == Qt::LeftButton) {
        toggleCalendar();
    }
    else { // Right-click
		KPopupMenu popup(m_parent);
        popup.insertItem(i18n("Configure &Clock"), this, SLOT(configure()));        
        popup.exec(QCursor::pos());
    }
}

/**
 * Get description
 */

QString Clock::getDescription() {
    return QDate::currentDate().toString("ddd dd MMM yyyy");
}

/**
 * Set clock's font face
 */

void Clock::setFontFace(QString fontFace)
{
    m_font.setFamily(fontFace);
}

/**
 * Set clock's font italic property
 */

void Clock::setFontItalic(bool val)
{
    m_font.setItalic(val);
}

/**
 * Set clock's font bold property
 */

void Clock::setFontBold(bool val)
{
    m_font.setBold(val);
}

/**
 * Set clock's font size
 */

void Clock::setFontSize(int size)
{
    m_font.setPointSize(size);
}

/**
 * Set clock's font color
 */

void Clock::setFontColor(QColor color)
{
    m_fontColor = color;
}

/**
 * Set using 24 (or 12) Hour Clock
 */

void Clock::set24HourClock(bool val) {
    m_use24HourClock = val;
    updateTime();
}

/**
 * Show/hide the calendar
 */

void Clock::toggleCalendar() {
    if (!m_calendar) {
        m_calendar = new DatePicker(NULL, QDate::currentDate());
        m_calendar->move( (QApplication::desktop()->width() - m_calendar->width()) / 2, (QApplication::desktop()->height() - m_calendar->height()) / 2 );
        m_calendar->show();
    } else {
        bool reshow = false;
        if (!m_calendar->isVisible())
            reshow = true;

        m_calendar->close();
        delete m_calendar;
        m_calendar = NULL;

        if (reshow) {
            m_calendar = new DatePicker(NULL, QDate::currentDate());
            m_calendar->move( (QApplication::desktop()->width() - m_calendar->width()) / 2, (QApplication::desktop()->height() - m_calendar->height()) / 2 );
            m_calendar->show();
        }
    }
}

/**
 * Timer event handler
 */

void Clock::updateTime() {
    QString clock_format;
    if (m_use24HourClock) {
        clock_format=QString("hh:mm");
    } else { // 12 Hour Clock
        clock_format=QString("h:mm ap");
    }
    QString s = QTime::currentTime().toString(clock_format);
    if (m_text != s) {
        m_text = s;
        m_parent->updateItem(m_itemId);
    }
}

/**
 * Configure the clock
 */

void Clock::configure() {
    m_parent->config(7);
}

#include "clock.moc"
