/***************************************************************************
 *   Copyright (C) 2006 by the KSmoothDock team   *
 *   dangvd@yahoo.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "dockitem.h"

/** 
 * Constructor
 */

DockItem::DockItem() {}

/** 
 * Constructor
 * @param parent the parent dock
 * @param itemId id of the item
 * @param desc description of the dock item
 * @param desktop the desktop the dock item is on
 * @param orientation orienation of the dock
 */

DockItem::DockItem(KSmoothDock* parent, int itemId, QString desc, int desktop, Qt::Orientation orientation)
 : m_parent(parent), m_itemId(itemId), m_description(desc), m_desktop(desktop), m_orientation(orientation) {};

/**
 * Return the virtual desktop this dock item is on
 */

int DockItem::getDesktop() {
    return m_desktop;
}

/**
 * Get the item id
 */

int DockItem::getItemId() {
    return m_itemId;
}

/**
 * Set description
 */

void DockItem::setDescription(QString s) {
    m_description = s;
}

/**
 * Get description
 */

QString DockItem::getDescription() {
    return m_description;
}


