/***************************************************************************
 *   Copyright (C) 2006 by the KSmoothDock team   *
 *   dangvd@yahoo.com   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef DOCKITEM_H
#define DOCKITEM_H

/**
 * @short Abstract base class for dock items
 * @author the KSmoothDock team <dangvd@yahoo.com>
 */

#include <qevent.h>
#include <qnamespace.h>
#include <qpixmap.h>

class KSmoothDock;

class DockItem {
public:
    /// Constructors
    DockItem();
    DockItem(KSmoothDock* parent, int itemId, QString desc, int desktop, Qt::Orientation orientation);

    /// Return the virtual desktop this dock item is on
    int getDesktop();

    /// Get the item id
    int getItemId();

    /// Set description
    void setDescription(QString s);

    /// Get description. This is virtual so dynamic description can be implemented in its subclasses
    virtual QString getDescription();

    /// Draw itself into the offscreen buffer
    virtual void draw(QPixmap& buffer, int x, int y, int size) = 0;

    /// Mouse pressed event handler
    virtual void mousePressEvent(QMouseEvent* e) = 0;

    /// Get max width
    virtual int getMaxWidth() = 0;
    
    /// Get max height
    virtual int getMaxHeight() = 0;

    /// Get min width
    virtual int getMinWidth() = 0;
    
    /// Get min height
    virtual int getMinHeight() = 0;

    /// Get width for a specific size
    virtual int getWidth(int size) = 0;
    
    /// Get height for a specific size
    virtual int getHeight(int size) = 0;

protected:
    KSmoothDock* m_parent; // the dock parent
    int m_itemId; // unique item id
    QString m_description; // description of the dock item
    int m_desktop; // the virtual desktop this dock item is on 
    Qt::Orientation m_orientation; // orientation
};

#endif
